/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultPayloadProviderSEI;
import org.apache.camel.component.cxf.DefaultSEI;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.version.Version;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CxfSpringEndpoint
extends CxfEndpoint
implements ApplicationContextAware {
    private String beanId;
    private ApplicationContext applicationContext;

    public CxfSpringEndpoint(CxfComponent component, String address) throws Exception {
        super(address, component);
    }

    public CxfSpringEndpoint() {
    }

    private Class<?> getSEIClass() throws ClassNotFoundException {
        Class<?> answer = null;
        if (this.getServiceClass() != null) {
            answer = this.getServiceClass();
        }
        return answer;
    }

    @Override
    Client createClient() throws Exception {
        Class<?> cls = this.getSEIClass();
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(cls, (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && cls == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
            cls = this.getSEIClass();
        }
        if (cls != null) {
            ClientFactoryBean factoryBean = this.createClientFactoryBean(cls);
            this.setupClientFactoryBean(factoryBean, cls);
            QName serviceQName = null;
            try {
                serviceQName = factoryBean.getServiceName();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (serviceQName == null && this.getServiceLocalName() != null) {
                factoryBean.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
            }
            if (factoryBean.getEndpointName() == null && this.getEndpointLocalName() != null) {
                factoryBean.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
            }
            Client client = factoryBean.create();
            this.setupHandlers(factoryBean, client);
            return client;
        }
        ClientFactoryBean factoryBean = this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, null);
        QName serviceQName = null;
        try {
            serviceQName = factoryBean.getServiceName();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (serviceQName == null && this.getServiceLocalName() != null) {
            factoryBean.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (factoryBean.getEndpointName() == null && this.getEndpointLocalName() != null) {
            factoryBean.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        this.checkName(factoryBean.getEndpointName(), "endpoint/port name");
        this.checkName(factoryBean.getServiceName(), "service name");
        return factoryBean.create();
    }

    @Override
    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<?> cls = this.getSEIClass();
        if (this.getWsdlURL() == null && cls == null) {
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setServiceClass(DefaultPayloadProviderSEI.class.getName());
            }
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            if (!this.getDataFormat().equals((Object)DataFormat.POJO)) {
                answer = new ServerFactoryBean((ReflectionServiceFactoryBean)new WSDLServiceFactoryBean());
            } else {
                ObjectHelper.notNull(cls, (String)"serviceClass");
            }
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        if (answer.getServiceName() == null && this.getServiceLocalName() != null) {
            answer.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (answer.getEndpointName() == null && this.getEndpointLocalName() != null) {
            answer.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        if (cls == null) {
            this.checkName(answer.getEndpointName(), "endpoint/port name");
            this.checkName(answer.getServiceName(), "service name");
        }
        return answer;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String id) {
        this.beanId = id;
    }

    public void setServiceNamespace(String serviceNamespace) {
        QName qn = this.getServiceName();
        if (qn == null) {
            this.setServiceName(new QName(serviceNamespace, "local"));
        } else {
            this.setServiceName(new QName(serviceNamespace, qn.getLocalPart()));
        }
    }

    public String getServiceNamespace() {
        QName qn = this.getServiceName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setServiceLocalName(String serviceLocalName) {
        QName qn = this.getServiceName();
        if (qn == null) {
            this.setServiceName(new QName("", serviceLocalName));
        } else {
            this.setServiceName(new QName(qn.getNamespaceURI(), serviceLocalName));
        }
    }

    public String getServiceLocalName() {
        QName qn = this.getServiceName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public String getEndpointLocalName() {
        QName qn = this.getPortName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public void setEndpointLocalName(String endpointLocalName) {
        QName qn = this.getPortName();
        if (qn == null) {
            this.setPortName(new QName("", endpointLocalName));
        } else {
            this.setPortName(new QName(qn.getNamespaceURI(), endpointLocalName));
        }
    }

    public void setEndpointNamespace(String endpointNamespace) {
        QName qn = this.getPortName();
        if (qn == null) {
            this.setPortName(new QName(endpointNamespace, "local"));
        } else {
            this.setPortName(new QName(endpointNamespace, qn.getLocalPart()));
        }
    }

    public String getEndpointNamespace() {
        QName qn = this.getPortName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.applicationContext = ctx;
        if (this.bus == null) {
            if (Version.getCurrentVersion().startsWith("2.3")) {
                SpringBusFactory factory = new SpringBusFactory(ctx);
                this.bus = factory.createBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)this.bus, (ApplicationContext)ctx);
            } else {
                this.bus = BusWiringBeanFactoryPostProcessor.addDefaultBus((ApplicationContext)ctx);
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

