/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.CxfMessageSoapHeaderOutInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFMessageDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LoggerFactory.getLogger(CXFMessageDataFormatFeature.class);
    private static final Collection<Class<?>> REMOVING_IN_INTERCEPTORS = new ArrayList();
    private static final Collection<Class<?>> REMOVING_OUT_INTERCEPTORS;

    public void initialize(Client client, Bus bus) {
        this.setupEndpoint(client.getEndpoint());
    }

    public void initialize(Server server, Bus bus) {
        this.setupEndpoint(server.getEndpoint());
    }

    protected void setupEndpoint(Endpoint ep) {
        this.resetPartTypes(ep.getBinding());
        Class<Source> fmt = Source.class;
        if (ep.getBinding() instanceof SoapBinding) {
            ep.getInInterceptors().add(new SAAJInInterceptor());
            SAAJOutInterceptor out = new SAAJOutInterceptor();
            ep.getOutInterceptors().add(out);
            ep.getOutInterceptors().add(new CxfMessageSoapHeaderOutInterceptor());
            ep.getOutInterceptors().add(new MessageModeOutInterceptor(out, ep.getBinding().getBindingInfo().getName()));
            fmt = SOAPMessage.class;
        } else {
            ep.getOutInterceptors().add(new MessageModeOutInterceptor(Source.class, ep.getBinding().getBindingInfo().getName()));
        }
        ep.getInInterceptors().add(new MessageModeInInterceptor(fmt, ep.getBinding().getBindingInfo().getName()));
        ep.put((Object)AbstractInDatabindingInterceptor.NO_VALIDATE_PARTS, (Object)Boolean.TRUE);
        this.removeInterceptors(ep.getInInterceptors(), REMOVING_IN_INTERCEPTORS);
        this.removeInterceptors(ep.getOutInterceptors(), REMOVING_OUT_INTERCEPTORS);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    private void resetPartTypes(Binding bop2) {
        for (BindingOperationInfo bop : bop2.getBindingInfo().getOperations()) {
            this.resetPartTypes(bop);
        }
    }

    private void resetPartTypes(BindingOperationInfo bop) {
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop.isUnwrappedCapable()) {
            this.resetPartTypeClass(bop.getWrappedOperation().getOperationInfo().getInput());
            this.resetPartTypeClass(bop.getWrappedOperation().getOperationInfo().getOutput());
            this.resetPartTypeClass(bop.getWrappedOperation().getInput());
            this.resetPartTypeClass(bop.getWrappedOperation().getOutput());
        }
        this.resetPartTypeClass(bop.getOperationInfo().getInput());
        this.resetPartTypeClass(bop.getOperationInfo().getOutput());
        this.resetPartTypeClass(bop.getInput());
        this.resetPartTypeClass(bop.getOutput());
    }

    protected void resetPartTypeClass(BindingMessageInfo bmi) {
        if (bmi != null) {
            int size = bmi.getMessageParts().size();
            for (int x = 0; x < size; ++x) {
                ((MessagePartInfo)bmi.getMessageParts().get(x)).setTypeClass(Source.class);
            }
        }
    }

    protected void resetPartTypeClass(MessageInfo msgInfo) {
        if (msgInfo != null) {
            int size = msgInfo.getMessageParts().size();
            for (int x = 0; x < size; ++x) {
                ((MessagePartInfo)msgInfo.getMessageParts().get(x)).setTypeClass(Source.class);
            }
        }
    }

    static {
        REMOVING_IN_INTERCEPTORS.add(HolderInInterceptor.class);
        REMOVING_IN_INTERCEPTORS.add(WrapperClassInInterceptor.class);
        REMOVING_OUT_INTERCEPTORS = new ArrayList();
        REMOVING_OUT_INTERCEPTORS.add(HolderOutInterceptor.class);
        REMOVING_OUT_INTERCEPTORS.add(WrapperClassOutInterceptor.class);
    }
}

