/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfAroundProcessor;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.CxfSoapEndpoint;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.component.cxf.util.NullConduit;
import org.apache.camel.component.cxf.util.NullDestinationFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.MessageObserver;

public class CxfSoapConsumer
implements Consumer {
    private static final Log LOG = LogFactory.getLog(CxfSoapConsumer.class);
    private final CxfSoapEndpoint endpoint;
    private final Consumer consumer;
    private MessageObserver inMessageObserver;
    private Server server;

    public CxfSoapConsumer(CxfSoapEndpoint endpoint, Processor processor) throws Exception {
        this.endpoint = endpoint;
        CxfAroundProcessor soapProcessor = new CxfAroundProcessor(processor, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapConsumer.this.processSoapConsumerIn(exchange);
            }
        }, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CxfSoapConsumer.this.processSoapConsumerOut(exchange);
            }
        });
        this.consumer = endpoint.getInnerEndpoint().createConsumer((Processor)soapProcessor);
        Class sei = null;
        if (ObjectHelper.isNotEmpty((Object)endpoint.getServiceClass())) {
            sei = ClassLoaderUtils.loadClass((String)endpoint.getServiceClass(), this.getClass());
        }
        ServerFactoryBean sfb = CxfEndpointUtils.getServerFactoryBean(sei);
        sfb.setWsdlURL(endpoint.getWsdl().getURL().toString());
        if (endpoint.getServiceName() != null) {
            sfb.setServiceName(endpoint.getServiceName());
        }
        if (endpoint.getEndpointName() != null) {
            sfb.setEndpointName(endpoint.getEndpointName());
        }
        sfb.setDestinationFactory((DestinationFactory)new NullDestinationFactory());
        sfb.setStart(false);
        this.server = sfb.create();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void start() throws Exception {
        this.server.start();
        this.inMessageObserver = this.server.getDestination().getMessageObserver();
        this.consumer.start();
    }

    public void stop() throws Exception {
        this.consumer.stop();
        this.server.stop();
    }

    protected Bus getBus() {
        return this.endpoint.getBus();
    }

    protected void processSoapConsumerIn(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processSoapConsumerIn: " + exchange));
        }
        Message inMessage = CxfSoapBinding.getCxfInMessage(this.endpoint.getHeaderFilterStrategy(), exchange, false);
        org.apache.cxf.message.Exchange cxfExchange = inMessage.getExchange();
        cxfExchange.put(org.apache.cxf.endpoint.Endpoint.class, (Object)this.server.getEndpoint());
        cxfExchange.put(Bus.class, (Object)this.getBus());
        cxfExchange.setConduit((Conduit)new NullConduit());
        this.inMessageObserver.onMessage(inMessage);
        exchange.getIn().setBody(inMessage.getContent(Source.class));
        exchange.getIn().setHeaders((Map)inMessage);
    }

    protected void processSoapConsumerOut(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processSoapConsumerOut: " + exchange));
        }
        Message outMessage = CxfSoapBinding.getCxfOutMessage(this.endpoint.getHeaderFilterStrategy(), exchange, false);
        org.apache.cxf.message.Exchange cxfExchange = outMessage.getExchange();
        InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((org.apache.cxf.message.Exchange)cxfExchange);
        outMessage.setInterceptorChain(chain);
        chain.doIntercept(outMessage);
        CachedOutputStream outputStream = (CachedOutputStream)outMessage.getContent(OutputStream.class);
        exchange.getOut().setBody((Object)outputStream.getInputStream());
    }
}

