/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.cxfbean.CxfBeanEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;

public class CxfBeanComponent
extends HeaderFilterStrategyComponent {
    private Map<String, CxfBeanEndpoint> endpoints = new HashMap<String, CxfBeanEndpoint>();

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        CxfBeanEndpoint answer = new CxfBeanEndpoint(remaining, this);
        this.setEndpointHeaderFilterStrategy((Endpoint)answer);
        this.setProperties((Object)answer, parameters);
        this.endpoints.put(answer.createEndpointUri(), answer);
        answer.init();
        return answer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (CxfBeanEndpoint endpoint : this.endpoints.values()) {
            endpoint.start();
        }
    }

    protected void doStop() throws Exception {
        for (CxfBeanEndpoint endpoint : this.endpoints.values()) {
            endpoint.stop();
        }
        super.doStop();
    }

    public CxfBeanEndpoint getEndpoint(String endpointUri) {
        return this.endpoints.get(endpointUri);
    }
}

