/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.interceptors.AbstractMessageOutInterceptor;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.cxf.bindings.xformat.XMLBindingMessageFormat;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageOutInterceptor
extends AbstractMessageOutInterceptor<XMLMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLMessageOutInterceptor.class);

    public XMLMessageOutInterceptor() {
        super("prepare-send");
        this.addAfter(DOMOutInterceptor.class.getName());
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public void handleMessage(XMLMessage message) throws Fault {
        Exchange exchange = message.getExchange();
        BindingMessageInfo bmi = (BindingMessageInfo)exchange.get(BindingMessageInfo.class);
        ArrayList<Element> payload = (ArrayList<Element>)message.get(List.class);
        if (bmi == null && payload.size() > 1) {
            throw new Fault(new Message("NO_XML_ROOT_NODE", LOG, new Object[0]));
        }
        if (bmi != null) {
            QName rootName;
            XMLBindingMessageFormat msgFormat = (XMLBindingMessageFormat)bmi.getExtensor(XMLBindingMessageFormat.class);
            QName qName = rootName = msgFormat != null ? msgFormat.getRootNode() : null;
            if (rootName == null) {
                if (payload.size() > 1) {
                    throw new Fault(new Message("NO_XML_ROOT_NODE", LOG, new Object[0]));
                }
            } else {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("DOMOutInterceptor Create xmlformat RootNode element");
                }
                Element el = this.createElement(rootName, (List<Element>)payload);
                payload = new ArrayList<Element>();
                payload.add(el);
            }
            message.put(List.class, (Object)payload);
            message.remove(Element.class);
        }
    }
}

