/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Holder;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultCxfBinding
implements CxfBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateCxfRequestFromExchange(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange, Map<String, Object> requestContext) {
        Map camelHeaders = camelExchange.getIn().getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, requestContext, "RequestContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, requestContext);
        String overrideAddress = (String)camelExchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (overrideAddress != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Client address is overridden by header 'CamelDestinationOverrideUrl' to value '" + overrideAddress + "'");
            }
            requestContext.put(org.apache.cxf.message.Message.ENDPOINT_ADDRESS, overrideAddress);
        }
        HashSet<AttachmentImpl> attachments = null;
        boolean isXop = Boolean.valueOf((String)camelExchange.getProperty("mtom-enabled", String.class));
        for (Map.Entry entry : camelExchange.getIn().getAttachments().entrySet()) {
            if (attachments == null) {
                attachments = new HashSet<AttachmentImpl>();
            }
            AttachmentImpl attachment = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
            attachment.setXOP(isXop);
            attachments.add(attachment);
        }
        if (attachments != null) {
            requestContext.put("CamelAttachments", attachments);
        }
    }

    @Override
    public void populateExchangeFromCxfResponse(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> responseContext) {
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        if (cxfMessage == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Populate exchange from CXF response message: " + cxfMessage);
        }
        camelExchange.getOut().setBody(DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class))));
        if (responseContext != null && responseContext.size() > 0 && !this.headerFilterStrategy.applyFilterToExternalHeaders("ResponseContext", responseContext, camelExchange)) {
            camelExchange.getOut().setHeader("ResponseContext", responseContext);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set header = ResponseContext value = " + responseContext);
            }
        }
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getOut(), camelExchange);
        if (cxfMessage.getAttachments() != null) {
            cxfMessage.getAttachments().size();
            for (Attachment attachment : cxfMessage.getAttachments()) {
                camelExchange.getOut().addAttachment(attachment.getId(), attachment.getDataHandler());
            }
        }
    }

    @Override
    public void populateExchangeFromCxfRequest(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
        Object body;
        Object value;
        Method method = null;
        QName operationName = null;
        ExchangePattern mep = ExchangePattern.InOut;
        BindingOperationInfo boi = (BindingOperationInfo)camelExchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        if (boi != null) {
            MethodDispatcher md;
            Service service = (Service)cxfExchange.get(Service.class);
            if (service != null && (md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName())) != null) {
                method = md.getMethod(boi);
            }
            if (boi.getOperationInfo().isOneWay()) {
                mep = ExchangePattern.InOnly;
            }
            operationName = boi.getName();
        }
        if (operationName != null) {
            camelExchange.getIn().setHeader("operationNamespace", (Object)boi.getName().getNamespaceURI());
            camelExchange.getIn().setHeader("operationName", (Object)boi.getName().getLocalPart());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set IN header: operationNamespace=" + boi.getName().getNamespaceURI());
                LOG.trace("Set IN header: operationName=" + boi.getName().getLocalPart());
            }
        } else if (method != null) {
            camelExchange.getIn().setHeader("operationName", (Object)method.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set IN header: operationName=" + method.getName());
            }
        }
        camelExchange.setPattern(mep);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Set exchange MEP: " + mep);
        }
        org.apache.cxf.message.Message cxfMessage = cxfExchange.getInMessage();
        this.propagateHeadersFromCxfToCamel(cxfMessage, camelExchange.getIn(), camelExchange);
        SecurityContext securityContext = (SecurityContext)cxfMessage.get(SecurityContext.class);
        if (securityContext != null && securityContext.getUserPrincipal() != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(securityContext.getUserPrincipal());
            camelExchange.getIn().getHeaders().put("CamelAuthentication", subject);
        }
        if ((value = cxfMessage.get((Object)"RequestContext")) != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("RequestContext", value, camelExchange)) {
            camelExchange.getIn().setHeader("RequestContext", value);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Populate context from CXF message RequestContext value=" + value);
            }
        }
        if ((body = DefaultCxfBinding.getContentFromCxf(cxfMessage, (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class)))) != null) {
            camelExchange.getIn().setBody(body);
        }
        if (cxfMessage.getAttachments() != null && !((DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class))).equals((Object)DataFormat.POJO)) {
            for (Attachment attachment : cxfMessage.getAttachments()) {
                camelExchange.getIn().addAttachment(attachment.getId(), attachment.getDataHandler());
            }
        }
    }

    @Override
    public void populateCxfResponseFromExchange(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) {
        BindingOperationInfo boi;
        Object outBody;
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        Map camelHeaders = camelExchange.getOut().getHeaders();
        this.extractInvocationContextFromCamel(camelExchange, camelHeaders, responseContext, "ResponseContext");
        this.propagateHeadersFromCamelToCxf(camelExchange, camelHeaders, cxfExchange, responseContext);
        Endpoint ep = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = ep.getBinding().createMessage();
        cxfExchange.setOutMessage(outMessage);
        DataFormat dataFormat = (DataFormat)((Object)camelExchange.getProperty("CamelCXFDataFormat", DataFormat.class));
        responseContext.remove("org.apache.cxf.client");
        outMessage.putAll(responseContext);
        outMessage.put((Object)"ResponseContext", responseContext);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Set out response context = " + responseContext);
        }
        if ((outBody = DefaultCxfBinding.getBodyFromCamel(camelExchange.getOut(), dataFormat)) != null) {
            if (dataFormat == DataFormat.PAYLOAD) {
                CxfPayload payload = (CxfPayload)outBody;
                outMessage.setContent(List.class, (Object)this.getResponsePayloadList(cxfExchange, payload.getBody()));
                outMessage.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                if (responseContext.get(Header.HEADER_LIST) != null) {
                    outMessage.put((Object)Header.HEADER_LIST, responseContext.get(Header.HEADER_LIST));
                }
                MessageContentsList resList = null;
                resList = outBody instanceof MessageContentsList ? (MessageContentsList)outBody : (outBody instanceof List ? new MessageContentsList((List)outBody) : (outBody.getClass().isArray() ? new MessageContentsList((Object[])outBody) : new MessageContentsList(new Object[]{outBody})));
                if (resList != null) {
                    outMessage.setContent(List.class, (Object)resList);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Set Out CXF message content = " + resList);
                    }
                }
            }
        }
        if (!DataFormat.POJO.equals((Object)dataFormat)) {
            HashSet<AttachmentImpl> attachments = null;
            boolean isXop = Boolean.valueOf((String)camelExchange.getProperty("mtom-enabled", String.class));
            for (Map.Entry entry : camelExchange.getOut().getAttachments().entrySet()) {
                if (attachments == null) {
                    attachments = new HashSet<AttachmentImpl>();
                }
                AttachmentImpl attachment = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
                attachment.setXOP(isXop);
                attachments.add(attachment);
            }
            if (attachments != null) {
                outMessage.setAttachments(attachments);
            }
        }
        if ((boi = (BindingOperationInfo)cxfExchange.get(BindingOperationInfo.class)) != null) {
            cxfExchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected MessageContentsList getResponsePayloadList(org.apache.cxf.message.Exchange exchange, List<Element> elements) {
        BindingOperationInfo boi = exchange.getBindingOperationInfo();
        if (boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            exchange.put(BindingOperationInfo.class, (Object)boi);
        }
        MessageContentsList answer = new MessageContentsList();
        int i = 0;
        for (MessagePartInfo partInfo : boi.getOutput().getMessageParts()) {
            if (elements.size() <= i) continue;
            answer.put(partInfo, (Object)elements.get(i++));
        }
        return answer;
    }

    protected void extractInvocationContextFromCamel(Exchange camelExchange, Map<String, Object> camelHeaders, Map<String, Object> cxfContext, String contextKey) {
        Map context = (Map)camelHeaders.get(contextKey);
        if (context != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Propagate " + contextKey + " from header context = " + (context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context));
            }
        }
        if ((context = (Map)camelExchange.getProperty(contextKey)) != null) {
            cxfContext.putAll(context);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Propagate " + contextKey + " from exchange property context = " + (context instanceof WrappedMessageContext ? ((WrappedMessageContext)context).getWrappedMap() : context));
            }
        }
        if (camelExchange.getProperties() != null) {
            cxfContext.putAll(camelExchange.getProperties());
        }
        camelExchange.setProperty(contextKey, cxfContext);
    }

    protected void propagateHeadersFromCxfToCamel(org.apache.cxf.message.Message cxfMessage, Message camelMessage, Exchange exchange) {
        String key;
        Object value;
        Map cxfHeaders = (Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS);
        Map camelHeaders = camelMessage.getHeaders();
        camelHeaders.put("CamelCxfMessage", cxfMessage);
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                if ("Content-Type".compareToIgnoreCase((String)entry.getKey()) == 0 && ((List)entry.getValue()).get(0) != null && ((String)((List)entry.getValue()).get(0)).startsWith("multipart/related")) {
                    String contentType = this.replaceMultiPartContentType((String)((List)entry.getValue()).get(0));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Find the multi-part Conent-Type, and replace it with " + contentType);
                    }
                    camelHeaders.put(entry.getKey(), contentType);
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Populate header from CXF header=" + (String)entry.getKey() + " value=" + entry.getValue());
                }
                camelHeaders.put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
        if ((value = cxfMessage.get((Object)(key = Header.HEADER_LIST))) != null) {
            if (!this.headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) {
                camelHeaders.put(key, value);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Populate header from CXF header=" + key + " value=" + value);
                }
            } else {
                ((List)value).clear();
            }
        }
    }

    protected String replaceMultiPartContentType(String contentType) {
        String[] parts;
        String result = "";
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("type=")) continue;
            if ((part = part.substring(5).trim()).charAt(0) == '\"') {
                result = part.substring(1, part.length() - 1);
                break;
            }
            result = part.substring(5);
            break;
        }
        return result;
    }

    protected void propagateHeadersFromCamelToCxf(Exchange camelExchange, Map<String, Object> camelHeaders, org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> cxfContext) {
        Map headers;
        Map h;
        HashMap<String, List> transportHeaders = new HashMap<String, List>();
        if (camelExchange != null && (h = (Map)camelExchange.getProperty(org.apache.cxf.message.Message.PROTOCOL_HEADERS)) != null) {
            transportHeaders.putAll(h);
        }
        if ((headers = (Map)camelHeaders.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS)) != null) {
            transportHeaders.putAll(headers);
        }
        for (Map.Entry<String, Object> entry : camelHeaders.entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), camelExchange)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Propagate to CXF header: " + entry.getKey() + " value: " + entry.getValue());
            }
            if (org.apache.cxf.message.Message.RESPONSE_CODE.equals(entry.getKey())) {
                cxfContext.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (Header.HEADER_LIST.equals(entry.getKey())) {
                List headerList = (List)entry.getValue();
                for (Header header : headerList) {
                    header.setDirection(Header.Direction.DIRECTION_OUT);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Propagate SOAP/protocol header: " + header.getName() + " : " + header.getObject());
                }
                cxfContext.put(entry.getKey(), headerList);
                continue;
            }
            if (entry.getValue() instanceof List) {
                transportHeaders.put(entry.getKey(), (List)entry.getValue());
                continue;
            }
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(entry.getValue().toString());
            transportHeaders.put(entry.getKey(), listValue);
        }
        if (transportHeaders.size() > 0) {
            cxfContext.put(org.apache.cxf.message.Message.PROTOCOL_HEADERS, transportHeaders);
        }
    }

    protected static Object getContentFromCxf(org.apache.cxf.message.Message message, DataFormat dataFormat) {
        Set contentFormats = message.getContentFormats();
        MessageContentsList answer = null;
        if (contentFormats != null) {
            if (LOG.isTraceEnabled()) {
                for (Class contentFormat : contentFormats) {
                    LOG.trace("Content format=" + contentFormat + " value=" + message.getContent(contentFormat));
                }
            }
            if (dataFormat == DataFormat.POJO) {
                answer = message.getContent(List.class);
                if (answer == null && (answer = message.getContent(Object.class)) != null) {
                    answer = new MessageContentsList(new Object[]{answer});
                }
            } else if (dataFormat == DataFormat.PAYLOAD) {
                List headers = CastUtils.cast((List)((List)message.get((Object)Header.HEADER_LIST)));
                answer = new CxfPayload(headers, DefaultCxfBinding.getPayloadBodyElements(message));
            } else if (dataFormat == DataFormat.MESSAGE) {
                answer = message.getContent(InputStream.class);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Extracted body from CXF message = " + answer);
            }
        }
        return answer;
    }

    protected static List<Element> getPayloadBodyElements(org.apache.cxf.message.Message message) {
        MessageContentsList inObjects = MessageContentsList.getContentsList((org.apache.cxf.message.Message)message);
        if (inObjects == null) {
            return null;
        }
        org.apache.cxf.message.Exchange exchange = message.getExchange();
        BindingOperationInfo boi = exchange.getBindingOperationInfo();
        OperationInfo op = boi.getOperationInfo();
        if (boi.isUnwrapped()) {
            op = boi.getWrappedOperation().getOperationInfo();
        }
        List partInfos = null;
        boolean client = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
        partInfos = client ? op.getOutput().getMessageParts() : op.getInput().getMessageParts();
        ArrayList<Element> answer = new ArrayList<Element>();
        for (MessagePartInfo partInfo : partInfos) {
            if (!inObjects.hasValue(partInfo)) continue;
            Object part = inObjects.get(partInfo);
            if (part instanceof Holder) {
                part = ((Holder)part).value;
            }
            if (part instanceof DOMSource) {
                Element element = DefaultCxfBinding.getFirstElement(((DOMSource)part).getNode());
                if (element != null) {
                    answer.add(element);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Extract body element " + (element == null ? "null" : XMLUtils.toString((Node)element)));
                continue;
            }
            if (part instanceof Element) {
                answer.add((Element)part);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Unhandled part type '" + part.getClass());
        }
        return answer;
    }

    public static Object getBodyFromCamel(Message out, DataFormat dataFormat) {
        Object answer = null;
        if (dataFormat == DataFormat.POJO) {
            answer = out.getBody();
        } else if (dataFormat == DataFormat.PAYLOAD) {
            answer = out.getBody(CxfPayload.class);
        } else if (dataFormat == DataFormat.MESSAGE) {
            answer = out.getBody(InputStream.class);
        }
        return answer;
    }

    private static Element getFirstElement(Node node) {
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return DOMUtils.getFirstElement((Node)node);
    }

    @Override
    public void copyJaxWsContext(org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> context) {
        if (cxfExchange.getOutMessage() != null) {
            org.apache.cxf.message.Message outMessage = cxfExchange.getOutMessage();
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (outMessage.get((Object)entry.getKey()) != null) continue;
                outMessage.put((Object)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void extractJaxWsContext(org.apache.cxf.message.Exchange cxfExchange, Map<String, Object> context) {
        org.apache.cxf.message.Message inMessage = cxfExchange.getInMessage();
        for (Map.Entry entry : inMessage.entrySet()) {
            if (!((String)entry.getKey()).startsWith("javax.xml.ws")) continue;
            context.put((String)entry.getKey(), entry.getValue());
        }
    }
}

