/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CamelContextHelper;

public class CxfComponent
extends HeaderFilterStrategyComponent {
    public CxfComponent() {
    }

    public CxfComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfEndpoint result = null;
        if (remaining.startsWith("bean:")) {
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            CxfEndpointBean bean = (CxfEndpointBean)((Object)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, CxfEndpointBean.class));
            result = new CxfSpringEndpoint(this, bean);
            if (bean.getProperties() != null) {
                HashMap copy = new HashMap();
                copy.putAll(bean.getProperties());
                this.setProperties((Object)result, copy);
                result.setMtomEnabled(Boolean.valueOf((String)copy.get("mtom-enabled")));
            }
        } else {
            result = new CxfEndpoint(remaining, this);
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        return result;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfEndpoint cxfEndpoint = (CxfEndpoint)endpoint;
        cxfEndpoint.updateEndpointUri(uri);
    }
}

