/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultCxfBinding;
import org.apache.camel.component.cxf.DefaultSEI;
import org.apache.camel.component.cxf.HybridSourceDataBinding;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.common.header.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CxfEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(CxfEndpoint.class);
    protected Bus bus;
    private String wsdlURL;
    private Class<?> serviceClass;
    private QName portName;
    private QName serviceName;
    private String defaultOperationName;
    private String defaultOperationNamespace;
    private boolean isWrapped;
    private Boolean wrappedStyle;
    private Boolean allowStreaming;
    private DataFormat dataFormat = DataFormat.POJO;
    private String publishedEndpointUrl;
    private boolean inOut = true;
    private CxfBinding cxfBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    private boolean isSetDefaultBus;
    private boolean loggingFeatureEnabled;
    private String address;
    private boolean mtomEnabled;
    private boolean skipPayloadMessagePartCheck;
    private Map<String, Object> properties;
    private List<Interceptor<? extends Message>> in = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> out = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> outFault = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> inFault = new ModCountCopyOnWriteArrayList();
    private List<AbstractFeature> features = new ModCountCopyOnWriteArrayList();
    private List<Handler> handlers;
    private List<String> schemaLocations;
    private String transportId;
    private String bindingId;
    private BindingConfiguration bindingConfig;
    private DataBinding dataBinding;
    private ReflectionServiceFactoryBean serviceFactoryBean;

    public CxfEndpoint(String remaining, CxfComponent cxfComponent) {
        super(remaining, (Component)cxfComponent);
        this.setAddress(remaining);
    }

    public CxfEndpoint(String remaining, CamelContext context) {
        super(remaining, context);
        this.setAddress(remaining);
    }

    public CxfEndpoint(String remaining) {
        super(remaining);
        this.setAddress(remaining);
    }

    public CxfEndpoint() {
    }

    public CxfEndpoint copy() {
        try {
            return (CxfEndpoint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public Producer createProducer() throws Exception {
        CxfProducer answer = new CxfProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void setupServerFactoryBean(ServerFactoryBean sfb, Class<?> cls) {
        sfb.setAddress(this.getAddress());
        sfb.setServiceClass(cls);
        sfb.setInInterceptors(this.in);
        sfb.setOutInterceptors(this.out);
        sfb.setOutFaultInterceptors(this.outFault);
        sfb.setInFaultInterceptors(this.inFault);
        sfb.setFeatures(this.features);
        if (this.schemaLocations != null) {
            sfb.setSchemaLocations(this.schemaLocations);
        }
        if (this.bindingConfig != null) {
            sfb.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            sfb.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            sfb.setServiceFactory(this.serviceFactoryBean);
        }
        if (sfb instanceof JaxWsServerFactoryBean && this.handlers != null) {
            ((JaxWsServerFactoryBean)sfb).setHandlers(this.handlers);
        }
        if (this.transportId != null) {
            sfb.setTransportId(this.transportId);
        }
        if (this.bindingId != null) {
            sfb.setBindingId(this.bindingId);
        }
        if (this.getWsdlURL() != null) {
            sfb.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            sfb.setServiceName(this.getServiceName());
        }
        if (this.getPortName() != null) {
            sfb.setEndpointName(this.getPortName());
        }
        if (!CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class)) {
            if (this.getDataFormat() == DataFormat.PAYLOAD) {
                sfb.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            } else if (this.getDataFormat() == DataFormat.MESSAGE) {
                sfb.getFeatures().add(new MessageDataFormatFeature());
            }
        } else {
            LOG.debug("Ignore DataFormat mode {} since SEI class is annotated with WebServiceProvider", (Object)this.getDataFormat());
        }
        if (this.loggingFeatureEnabled) {
            sfb.getFeatures().add(new LoggingFeature());
        }
        if (this.getDataFormat() == DataFormat.PAYLOAD) {
            sfb.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.getWrappedStyle() != null) {
            sfb.getServiceFactory().setWrapped(this.getWrappedStyle().booleanValue());
        }
        if (this.getProperties() != null) {
            if (sfb.getProperties() != null) {
                sfb.getProperties().putAll(this.getProperties());
            } else {
                sfb.setProperties(this.getProperties());
            }
            LOG.debug("ServerFactoryBean: {} added properties: {}", (Object)sfb, this.getProperties());
        }
        sfb.setBus(this.getBus());
        sfb.setStart(false);
    }

    protected ClientFactoryBean createClientFactoryBean(Class<?> cls) throws CamelException {
        if (CxfEndpointUtils.hasWebServiceAnnotation(cls)) {
            return new JaxWsClientFactoryBean(){

                protected Client createClient(Endpoint ep) {
                    return new CamelCxfClientImpl(this.getBus(), ep);
                }
            };
        }
        return new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }
        };
    }

    protected ClientFactoryBean createClientFactoryBean() {
        return new ClientFactoryBean(new WSDLServiceFactoryBean()){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }

            protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
            }
        };
    }

    protected void setupHandlers(ClientFactoryBean factoryBean, Client client) {
        if (factoryBean instanceof JaxWsClientFactoryBean && this.handlers != null) {
            AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
            JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)factoryBean.getServiceFactory();
            ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
            chain.addAll(builder.buildHandlerChainFromClass(sf.getServiceClass(), sf.getEndpointInfo().getName(), sf.getServiceQName(), factoryBean.getBindingId()));
            if (!chain.isEmpty()) {
                ResourceManager resourceManager = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
                List resolvers = resourceManager.getResourceResolvers();
                resourceManager = new DefaultResourceManager(resolvers);
                resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
                ResourceInjector injector = new ResourceInjector(resourceManager);
                for (Handler h : chain) {
                    if (Proxy.isProxyClass(h.getClass()) && this.getServiceClass() != null) {
                        injector.inject((Object)h, this.getServiceClass());
                        injector.construct((Object)h, this.getServiceClass());
                        continue;
                    }
                    injector.inject((Object)h);
                    injector.construct((Object)h);
                }
            }
            ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
        }
    }

    protected void setupClientFactoryBean(ClientFactoryBean factoryBean, Class<?> cls) {
        if (cls != null) {
            factoryBean.setServiceClass(cls);
        }
        factoryBean.setInInterceptors(this.in);
        factoryBean.setOutInterceptors(this.out);
        factoryBean.setOutFaultInterceptors(this.outFault);
        factoryBean.setInFaultInterceptors(this.inFault);
        factoryBean.setFeatures(this.features);
        factoryBean.setTransportId(this.transportId);
        factoryBean.setBindingId(this.bindingId);
        if (this.bindingConfig != null) {
            factoryBean.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            factoryBean.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            factoryBean.setServiceFactory(this.serviceFactoryBean);
        }
        factoryBean.setAddress(this.getAddress());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            factoryBean.setServiceName(this.getServiceName());
        }
        if (this.getPortName() != null) {
            factoryBean.setEndpointName(this.getPortName());
        }
        if (this.getDataFormat() == DataFormat.MESSAGE) {
            factoryBean.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            factoryBean.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.loggingFeatureEnabled) {
            factoryBean.getFeatures().add(new LoggingFeature());
        }
        if (this.getWrappedStyle() != null) {
            factoryBean.getServiceFactory().setWrapped(this.getWrappedStyle().booleanValue());
        }
        if (this.getProperties() != null) {
            if (factoryBean.getProperties() != null) {
                factoryBean.getProperties().putAll(this.getProperties());
            } else {
                factoryBean.setProperties(this.getProperties());
            }
            LOG.debug("ClientFactoryBean: {} added properties: {}", (Object)factoryBean, this.getProperties());
        }
        factoryBean.setBus(this.getBus());
    }

    Client createClient() throws Exception {
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
        }
        Class<?> cls = null;
        if (this.getServiceClass() != null) {
            cls = this.getServiceClass();
            ClientFactoryBean factoryBean = this.createClientFactoryBean(cls);
            this.setupClientFactoryBean(factoryBean, cls);
            Client client = factoryBean.create();
            this.setupHandlers(factoryBean, client);
            return client;
        }
        this.checkName(this.portName, "endpoint/port name");
        this.checkName(this.serviceName, "service name");
        ClientFactoryBean factoryBean = this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, null);
        return factoryBean.create();
    }

    void checkName(Object value, String name) {
        if (ObjectHelper.isEmpty((Object)value)) {
            LOG.warn("The " + name + " of " + this.getEndpointUri() + " is empty, cxf will try to load the first one in wsdl for you.");
        }
    }

    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<?> cls = null;
        if (this.getDataFormat() == DataFormat.POJO || this.getServiceClass() != null) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            this.checkName(this.portName, " endpoint/port name");
            this.checkName(this.serviceName, " service name");
            answer = new ServerFactoryBean((ReflectionServiceFactoryBean)new WSDLServiceFactoryBean());
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public String getPublishedEndpointUrl() {
        return this.publishedEndpointUrl;
    }

    public void setPublishedEndpointUrl(String url) {
        this.publishedEndpointUrl = url;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
    }

    public void setServiceClass(Object instance) {
        this.serviceClass = ClassHelper.getRealClass((Object)instance);
    }

    public void setServiceClass(String type) throws ClassNotFoundException {
        this.serviceClass = ClassLoaderUtils.loadClass((String)type, this.getClass());
    }

    public void setServiceName(QName service) {
        this.serviceName = service;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName port) {
        this.portName = port;
    }

    public void setEndpointName(QName port) {
        this.portName = port;
    }

    public String getDefaultOperationName() {
        return this.defaultOperationName;
    }

    public void setDefaultOperationName(String name) {
        this.defaultOperationName = name;
    }

    public String getDefaultOperationNamespace() {
        return this.defaultOperationNamespace;
    }

    public void setDefaultOperationNamespace(String namespace) {
        this.defaultOperationNamespace = namespace;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public Boolean getWrappedStyle() {
        return this.wrappedStyle;
    }

    public void setWrappedStyle(Boolean wrapped) {
        this.wrappedStyle = wrapped;
    }

    public void setAllowStreaming(Boolean b) {
        this.allowStreaming = b;
    }

    public Boolean getAllowStreaming() {
        return this.allowStreaming;
    }

    public void setCxfBinding(CxfBinding cxfBinding) {
        this.cxfBinding = cxfBinding;
    }

    public CxfBinding getCxfBinding() {
        return this.cxfBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = CxfEndpointUtils.createBus(this.getCamelContext());
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    protected boolean isSkipPayloadMessagePartCheck() {
        return this.skipPayloadMessagePartCheck;
    }

    protected void setSkipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
        this.skipPayloadMessagePartCheck = skipPayloadMessagePartCheck;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCamelContext(CamelContext c) {
        super.setCamelContext(c);
        if (this.properties != null) {
            try {
                EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
                EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll(properties);
        }
        if (this.getCamelContext() != null && this.properties != null) {
            try {
                EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
                EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfHeaderFilterStrategy();
        }
        if (this.cxfBinding == null) {
            this.cxfBinding = new DefaultCxfBinding();
        }
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
    }

    public void setAddress(String address) {
        super.setEndpointUri(address);
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault = interceptors;
    }

    public void setFeatures(List<AbstractFeature> f) {
        this.features = f;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setSchemaLocations(List<String> sc) {
        this.schemaLocations = sc;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public BindingConfiguration getBindingConfig() {
        return this.bindingConfig;
    }

    public void setBindingConfig(BindingConfiguration bindingConfig) {
        this.bindingConfig = bindingConfig;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public ReflectionServiceFactoryBean getServiceFactoryBean() {
        return this.serviceFactoryBean;
    }

    public void setServiceFactoryBean(ReflectionServiceFactoryBean serviceFactoryBean) {
        this.serviceFactoryBean = serviceFactoryBean;
    }

    class CamelCxfClientImpl
    extends ClientImpl {
        public CamelCxfClientImpl(Bus bus, Endpoint ep) {
            super(bus, ep);
        }

        public Bus getBus() {
            return this.bus;
        }

        protected void setParameters(Object[] params, Message message) {
            Object attachements = message.get((Object)"CamelAttachments");
            if (attachements != null) {
                message.setAttachments((Collection)attachements);
                message.remove((Object)"CamelAttachments");
            }
            if (DataFormat.PAYLOAD == message.get(DataFormat.class)) {
                CxfPayload payload = (CxfPayload)params[0];
                List<Source> elements = payload.getBodySources();
                BindingOperationInfo boi = (BindingOperationInfo)message.get(BindingOperationInfo.class);
                MessageContentsList content = new MessageContentsList();
                int i = 0;
                for (MessagePartInfo partInfo : boi.getInput().getMessageParts()) {
                    if (elements.size() <= i) continue;
                    if (CxfEndpoint.this.isSkipPayloadMessagePartCheck()) {
                        content.put(partInfo, (Object)elements.get(i++));
                        continue;
                    }
                    String name = this.findName(elements, i);
                    if (!partInfo.getConcreteName().getLocalPart().equals(name)) continue;
                    content.put(partInfo, (Object)elements.get(i++));
                }
                if (content.size() < elements.size()) {
                    LOG.warn("Cannot set right payload paremeters. Please check the BindingOperation and PayLoadMessage.");
                    throw new IllegalArgumentException("The PayLoad elements cannot fit with the message parts of the BindingOperation. Please check the BindingOperation and PayLoadMessage.");
                }
                message.setContent(List.class, (Object)content);
                message.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                super.setParameters(params, message);
            }
            message.remove(DataFormat.class);
        }

        private String findName(List<Source> sources, int i) {
            Source source = sources.get(i);
            if (source instanceof DOMSource) {
                return ((Element)((DOMSource)source).getNode()).getLocalName();
            }
            if (source instanceof StaxSource) {
                StaxSource s = (StaxSource)source;
                return s.getXMLStreamReader().getLocalName();
            }
            if (source instanceof StAXSource) {
                StAXSource s = (StAXSource)source;
                XMLStreamReader r = s.getXMLStreamReader();
                if (r.getEventType() != 1) {
                    try {
                        r.nextTag();
                    }
                    catch (XMLStreamException e) {
                        // empty catch block
                    }
                }
                return r.getLocalName();
            }
            return null;
        }
    }
}

