/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsHeaderFilterStrategy;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsEndpoint.class);
    protected Bus bus;
    private Map<String, String> parameters;
    private List<Class<?>> resourceClasses;
    private HeaderFilterStrategy headerFilterStrategy;
    private CxfRsBinding binding;
    private boolean httpClientAPI = true;
    private String address;
    private boolean throwExceptionOnFailure = true;
    private int maxClientCacheSize = 10;
    private AtomicBoolean bindingInitialized = new AtomicBoolean(false);
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    private boolean isSetDefaultBus;

    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.setAddress(endpointUri);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setAddress(endpointUri);
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public void setParameters(Map<String, String> param) {
        this.parameters = param;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setHttpClientAPI(boolean clientAPI) {
        this.httpClientAPI = clientAPI;
    }

    public boolean isHttpClientAPI() {
        return this.httpClientAPI;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfRsHeaderFilterStrategy();
            LOG.debug("Create default header filter strategy {}", (Object)this.headerFilterStrategy);
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfRsConsumer(this, processor);
    }

    public Producer createProducer() throws Exception {
        return new CxfRsProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
        this.bindingInitialized.set(false);
    }

    public synchronized CxfRsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultCxfRsBinding();
            LOG.debug("Create default CXF Binding {}", (Object)this.binding);
        }
        if (!this.bindingInitialized.getAndSet(true) && this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        return this.binding;
    }

    protected void checkBeanType(Object object, Class<?> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("The configure bean is not the instance of " + clazz.getName());
        }
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        if (this.getAddress() != null) {
            sfb.setAddress(this.getAddress());
        }
        if (this.getResourceClasses() != null) {
            sfb.setResourceClasses(CastUtils.cast(this.getResourceClasses(), Class.class));
        }
        sfb.setStart(false);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        if (address != null) {
            cfb.setAddress(address);
        }
        if (this.getResourceClasses() != null) {
            cfb.setResourceClass(this.getResourceClasses().get(0));
        }
        cfb.setThreadSafe(true);
    }

    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        return new JAXRSServerFactoryBean();
    }

    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        return new JAXRSClientFactoryBean();
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        JAXRSServerFactoryBean answer = this.newJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        return this.createJAXRSClientFactoryBean(this.getAddress());
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean(String address) {
        JAXRSClientFactoryBean answer = this.newJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer, address);
        return answer;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<Class<?>> classes) {
        this.resourceClasses = classes;
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setResourceClass(Class<?> clazz) {
        this.setResourceClasses(clazz);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public void setMaxClientCacheSize(int maxClientCacheSize) {
        this.maxClientCacheSize = maxClientCacheSize;
    }

    public int getMaxClientCacheSize() {
        return this.maxClientCacheSize;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = CxfEndpointUtils.createBus(this.getCamelContext());
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }
}

