/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfClientCallback;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CxfProducer.class);
    private Client client;
    private CxfEndpoint endpoint;

    public CxfProducer(CxfEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        if (this.client == null) {
            this.client = this.endpoint.createClient();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.destroy();
            this.client = null;
        }
    }

    public boolean process(Exchange camelExchange, AsyncCallback callback) {
        LOG.trace("Process exchange: {} in an async way.", (Object)camelExchange);
        try {
            ExchangeImpl cxfExchange = new ExchangeImpl();
            cxfExchange.put(Bus.class, (Object)this.endpoint.getBus());
            BindingOperationInfo boi = this.prepareBindingOperation(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange);
            HashMap<String, Map<Object, Object>> invocationContext = new HashMap<String, Map<Object, Object>>();
            HashMap responseContext = new HashMap();
            invocationContext.put("ResponseContext", responseContext);
            invocationContext.put("RequestContext", this.prepareRequest(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange));
            CxfClientCallback cxfClientCallback = new CxfClientCallback(callback, camelExchange, (org.apache.cxf.message.Exchange)cxfExchange, boi, this.endpoint.getCxfBinding());
            this.client.invoke((ClientCallback)cxfClientCallback, boi, this.getParams(this.endpoint, camelExchange), invocationContext, (org.apache.cxf.message.Exchange)cxfExchange);
            if (boi.getOperationInfo().isOneWay()) {
                callback.done(false);
            }
        }
        catch (Throwable ex) {
            camelExchange.setException(ex);
            callback.done(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange camelExchange) throws Exception {
        LOG.trace("Process exchange: {} in sync way.", (Object)camelExchange);
        ExchangeImpl cxfExchange = new ExchangeImpl();
        cxfExchange.put(Bus.class, (Object)this.endpoint.getBus());
        BindingOperationInfo boi = this.prepareBindingOperation(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange);
        HashMap<String, Map<String, Object>> invocationContext = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        invocationContext.put("ResponseContext", responseContext);
        invocationContext.put("RequestContext", this.prepareRequest(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange));
        try {
            this.client.invoke(boi, this.getParams(this.endpoint, camelExchange), invocationContext, (org.apache.cxf.message.Exchange)cxfExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        finally {
            if (!boi.getOperationInfo().isOneWay()) {
                camelExchange.getOut().getHeaders().putAll(camelExchange.getIn().getHeaders());
                this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(camelExchange, (org.apache.cxf.message.Exchange)cxfExchange, responseContext);
            }
        }
    }

    protected Map<String, Object> prepareRequest(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        WrappedMessageContext requestContext = new WrappedMessageContext(new HashMap(), null, MessageContext.Scope.APPLICATION);
        camelExchange.setProperty("mtom-enabled", (Object)String.valueOf(this.endpoint.isMtomEnabled()));
        DataFormat dataFormat = this.endpoint.getDataFormat();
        camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
        LOG.trace("Set Camel Exchange property: {}={}", (Object)DataFormat.class.getName(), (Object)dataFormat);
        requestContext.put(DataFormat.class.getName(), (Object)dataFormat);
        if (dataFormat == DataFormat.MESSAGE) {
            cxfExchange.put((Object)"KeepConduitAlive", (Object)true);
            LOG.trace("Set CXF Exchange property: {}={}", (Object)"KeepConduitAlive", (Object)true);
        }
        this.endpoint.getCxfBinding().populateCxfRequestFromExchange(cxfExchange, camelExchange, (Map<String, Object>)requestContext);
        requestContext.getScopes().remove(Message.PROTOCOL_HEADERS);
        return requestContext.getWrappedMap();
    }

    private BindingOperationInfo prepareBindingOperation(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) {
        BindingOperationInfo boi = this.getBindingOperationInfo(camelExchange);
        ObjectHelper.notNull((Object)boi, (String)"BindingOperationInfo");
        if (this.endpoint.getDataFormat() == DataFormat.PAYLOAD && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            cxfExchange.put(BindingOperationInfo.class, (Object)boi);
        }
        camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
        LOG.trace("Set exchange property: BindingOperationInfo: {}", (Object)boi);
        if (this.endpoint.getDataFormat() != DataFormat.PAYLOAD && !this.endpoint.isWrapped() && boi != null && boi.isUnwrappedCapable()) {
            boi = boi.getUnwrappedOperation();
            LOG.trace("Unwrapped BOI {}", (Object)boi);
        }
        return boi;
    }

    private void checkParameterSize(CxfEndpoint endpoint, Exchange exchange, Object[] parameters) {
        int experctMessagePartsSize;
        BindingOperationInfo boi = this.getBindingOperationInfo(exchange);
        if (boi == null) {
            throw new RuntimeCamelException("Can't find the binding operation information from camel exchange");
        }
        if (!endpoint.isWrapped() && boi.isUnwrappedCapable()) {
            boi = boi.getUnwrappedOperation();
        }
        if (parameters.length < (experctMessagePartsSize = boi.getInput().getMessageParts().size())) {
            throw new IllegalArgumentException("Get the wrong parameter size to invoke the out service, Expect size " + experctMessagePartsSize + ", Parameter size " + parameters.length + ". Please check if the message body matches the CXFEndpoint POJO Dataformat request.");
        }
        if (parameters.length > experctMessagePartsSize) {
            List headers;
            int holdersSize = 0;
            for (Object parameter : parameters) {
                if (!(parameter instanceof Holder)) continue;
                ++holdersSize;
            }
            int soapHeadersSize = 0;
            BindingMessageInfo bmi = boi.getInput();
            if (bmi != null && (headers = bmi.getExtensors(SoapHeaderInfo.class)) != null) {
                soapHeadersSize = headers.size();
            }
            if (holdersSize + experctMessagePartsSize + soapHeadersSize < parameters.length) {
                throw new IllegalArgumentException("Get the wrong parameter size to invoke the out service, Expect size " + (experctMessagePartsSize + holdersSize + soapHeadersSize) + ", Parameter size " + parameters.length + ". Please check if the message body matches the CXFEndpoint POJO Dataformat request.");
            }
        }
    }

    private Object[] getParams(CxfEndpoint endpoint, Exchange exchange) throws InvalidPayloadException {
        Object[] params = null;
        if (endpoint.getDataFormat() == DataFormat.POJO) {
            Object body = exchange.getIn().getBody();
            if (body instanceof Object[]) {
                params = (Object[])body;
            } else if (body instanceof List) {
                params = ((List)body).toArray();
            } else {
                List list;
                Iterator it = (Iterator)exchange.getIn().getBody(Iterator.class);
                if (it != null && it.hasNext() && (list = (List)exchange.getContext().getTypeConverter().convertTo(List.class, (Object)it)) != null) {
                    params = list.toArray();
                }
                if (params == null) {
                    params = new Object[]{exchange.getIn().getBody()};
                }
            }
            this.checkParameterSize(endpoint, exchange, params);
        } else if (endpoint.getDataFormat() == DataFormat.PAYLOAD) {
            params = new Object[]{exchange.getIn().getMandatoryBody(CxfPayload.class)};
        } else if (endpoint.getDataFormat() == DataFormat.MESSAGE) {
            params = new Object[]{exchange.getIn().getMandatoryBody(InputStream.class)};
        }
        if (LOG.isTraceEnabled() && params != null) {
            for (int i = 0; i < params.length; ++i) {
                LOG.trace("params[{}] = {}", (Object)i, params[i]);
            }
        }
        return params;
    }

    private BindingOperationInfo getBindingOperationInfo(Exchange ex) {
        CxfEndpoint endpoint = (CxfEndpoint)this.getEndpoint();
        BindingOperationInfo answer = null;
        String lp = (String)ex.getIn().getHeader("operationName", String.class);
        if (lp == null) {
            lp = endpoint.getDefaultOperationName();
        }
        if (lp == null) {
            LOG.debug("Try to find a default operation. You should set '{}' in header.", (Object)"operationName");
            Collection bois = this.client.getEndpoint().getEndpointInfo().getBinding().getOperations();
            Iterator iter = bois.iterator();
            if (iter.hasNext()) {
                answer = (BindingOperationInfo)iter.next();
            }
        } else {
            String ns = (String)ex.getIn().getHeader("operationNamespace", String.class);
            if (ns == null) {
                ns = endpoint.getDefaultOperationNamespace();
            }
            if (ns == null) {
                ns = this.client.getEndpoint().getService().getName().getNamespaceURI();
                LOG.trace("Operation namespace not in header. Set it to: {}", (Object)ns);
            }
            QName qname = new QName(ns, lp);
            LOG.trace("Operation qname = {}", (Object)qname.toString());
            answer = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(qname);
            if (answer == null) {
                throw new IllegalArgumentException("Can't find the BindingOperationInfo with operation name " + qname + ". Please check the message headers of operationName and operationNamespace.");
            }
        }
        return answer;
    }

    public Client getClient() {
        return this.client;
    }
}

