/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import javax.xml.transform.Source;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.converter.CxfPayloadConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CxfPayloadConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        CxfPayloadConverterLoader.addTypeConverter(registry, Source.class, CxfPayload.class, false, (type, exchange, value) -> CxfPayloadConverter.cxfPayLoadToSource((CxfPayload)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, StreamCache.class, CxfPayload.class, false, (type, exchange, value) -> CxfPayloadConverter.cxfPayLoadToStreamCache((CxfPayload)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, CxfPayload.class, Source.class, false, (type, exchange, value) -> CxfPayloadConverter.sourceToCxfPayload((Source)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, CxfPayload.class, Document.class, false, (type, exchange, value) -> CxfPayloadConverter.documentToCxfPayload((Document)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, CxfPayload.class, Element.class, false, (type, exchange, value) -> CxfPayloadConverter.elementToCxfPayload((Element)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, CxfPayload.class, NodeList.class, false, (type, exchange, value) -> CxfPayloadConverter.nodeListToCxfPayload((NodeList)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, Node.class, CxfPayload.class, false, (type, exchange, value) -> CxfPayloadConverter.cxfPayLoadToNode((CxfPayload)value, exchange));
        CxfPayloadConverterLoader.addTypeConverter(registry, NodeList.class, CxfPayload.class, false, (type, exchange, value) -> CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        CxfPayloadConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> CxfPayloadConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

