/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.Mapper;
import com.datasonnet.MapperBuilder;
import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.spi.Library;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.language.datasonnet.CML;
import org.apache.camel.language.datasonnet.DatasonnetLanguage;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasonnetExpression
extends ExpressionAdapter
implements ExpressionResultTypeAware {
    private static final Logger LOG = LoggerFactory.getLogger(DatasonnetExpression.class);
    private final String expression;
    private Expression source;
    private MediaType bodyMediaType;
    private MediaType outputMediaType;
    private Class<?> resultType;
    private Collection<String> libraryPaths;
    private transient DatasonnetLanguage language;

    public DatasonnetExpression(String expression) {
        this.expression = expression;
    }

    @Deprecated
    public static DatasonnetExpression builder(String expression) {
        return new DatasonnetExpression(expression);
    }

    @Deprecated
    public static DatasonnetExpression builder(String expression, Class<?> resultType) {
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        answer.setResultType(resultType);
        return answer;
    }

    public boolean matches(Exchange exchange) {
        this.outputMediaType = MediaTypes.APPLICATION_JAVA;
        return this.evaluate(exchange, Boolean.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            CML.getInstance().getExchange().set(exchange);
            Document<?> result = this.doEvaluate(exchange);
            if (!type.equals(Object.class)) {
                Object object = ExchangeHelper.convertToType((Exchange)exchange, type, (Object)result.getContent());
                return (T)object;
            }
            if (this.resultType == null || this.resultType.equals(Document.class)) {
                Document<?> document = result;
                return (T)document;
            }
            Object object = result.getContent();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Unable to evaluate DataSonnet expression: " + this.expression, (Throwable)e);
        }
        finally {
            CML.getInstance().getExchange().remove();
        }
    }

    private Document<?> doEvaluate(Exchange exchange) {
        String typeHeader;
        MediaType bodyMT = this.bodyMediaType;
        if (bodyMT == null && !this.expression.startsWith("/** DataSonnet") && (typeHeader = (String)exchange.getProperty("CamelDatasonnetBodyMediaType", exchange.getIn().getHeader("Content-Type"), String.class)) != null) {
            bodyMT = MediaType.valueOf((String)typeHeader);
        }
        Object payload = this.source != null ? this.source.evaluate(exchange, Object.class) : exchange.getMessage().getBody();
        Document doc = null;
        if (payload != null) {
            doc = (Document)exchange.getContext().getTypeConverter().tryConvertTo(Document.class, exchange, payload);
        }
        if (doc == null) {
            String text = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, payload);
            doc = exchange.getMessage().getBody() == null || "".equals(text) ? new DefaultDocument((Object)"", MediaTypes.APPLICATION_JAVA) : (MediaTypes.APPLICATION_JAVA.equalsTypeAndSubtype(bodyMT) || bodyMT == null ? new DefaultDocument(payload) : new DefaultDocument((Object)text, bodyMT));
        }
        Mapper mapper = this.language.lookup(this.expression).orElseThrow(() -> new IllegalStateException("Datasonnet expression not initialized"));
        MediaType outMT = this.outputMediaType;
        if (outMT == null) {
            String typeHeader2 = (String)exchange.getProperty("CamelDatasonnetOutputMediaType", exchange.getIn().getHeader("CamelDatasonnetOutputMediaType"), String.class);
            outMT = typeHeader2 != null ? MediaType.valueOf((String)typeHeader2) : MediaTypes.ANY;
        }
        Map<String, Document> inputs = Collections.singletonMap("body", doc);
        if (this.resultType == null || this.resultType.equals(Document.class)) {
            return mapper.transform(doc, inputs, outMT, Object.class);
        }
        return mapper.transform(doc, inputs, outMT, this.resultType);
    }

    private Map<String, String> resolveImports(DatasonnetLanguage language) {
        if (this.libraryPaths == null) {
            return language.getClasspathImports();
        }
        final HashMap<String, String> answer = new HashMap<String, String>();
        LOG.debug("Explicit library path is: {}", this.libraryPaths);
        for (String nextPath : this.libraryPaths) {
            final File nextLibDir = new File(nextPath);
            if (!nextLibDir.isDirectory()) continue;
            try {
                Files.walkFileTree(nextLibDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        File f = file.toFile();
                        if (!f.isDirectory() && f.getName().toLowerCase().endsWith(".libsonnet")) {
                            String content = IOUtils.toString((URI)file.toUri(), (Charset)Charset.defaultCharset());
                            Path relative = nextLibDir.toPath().relativize(file);
                            LOG.debug("Loading DataSonnet library: {}", (Object)relative);
                            answer.put(relative.toString(), content);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.warn("Unable to load DataSonnet library from: {}", (Object)nextPath, (Object)e);
            }
        }
        return answer;
    }

    public void init(CamelContext context) {
        super.init(context);
        this.language = (DatasonnetLanguage)context.resolveLanguage("datasonnet");
        this.language.computeIfMiss(this.expression, () -> {
            MapperBuilder builder = new MapperBuilder(this.expression).withInputNames(new String[]{"body"}).withImports(this.resolveImports(this.language)).withLibrary((Library)CML.getInstance()).withDefaultOutput(MediaTypes.APPLICATION_JAVA);
            Set additionalLibraries = context.getRegistry().findByType(Library.class);
            for (Library lib : additionalLibraries) {
                builder = builder.withLibrary(lib);
            }
            return builder.build();
        });
    }

    public Expression getSource() {
        return this.source;
    }

    public void setSource(Expression source) {
        this.source = source;
    }

    public MediaType getBodyMediaType() {
        return this.bodyMediaType;
    }

    public void setBodyMediaType(MediaType inputMimeType) {
        this.bodyMediaType = inputMimeType;
    }

    public MediaType getOutputMediaType() {
        return this.outputMediaType;
    }

    public void setOutputMediaType(MediaType outputMimeType) {
        this.outputMediaType = outputMimeType;
    }

    public Collection<String> getLibraryPaths() {
        return this.libraryPaths;
    }

    public void setLibraryPaths(Collection<String> libraryPaths) {
        this.libraryPaths = libraryPaths;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> targetType) {
        this.resultType = targetType;
    }

    @Deprecated
    public DatasonnetExpression bodyMediaType(MediaType bodyMediaType) {
        this.setBodyMediaType(bodyMediaType);
        return this;
    }

    @Deprecated
    public DatasonnetExpression outputMediaType(MediaType outputMediaType) {
        this.setOutputMediaType(outputMediaType);
        return this;
    }

    public String toString() {
        return "datasonnet: " + this.expression;
    }
}

