/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

public abstract class DebeziumComponent<C extends EmbeddedDebeziumConfiguration>
extends DefaultComponent {
    protected DebeziumComponent() {
    }

    protected DebeziumComponent(CamelContext context) {
        super(context);
    }

    protected DebeziumEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ConfigurationValidation configurationValidation;
        C configuration = this.getConfiguration();
        if (ObjectHelper.isEmpty((Object)remaining) && ObjectHelper.isEmpty((Object)((EmbeddedDebeziumConfiguration)configuration).getName())) {
            throw new IllegalArgumentException(String.format("Connector name must be configured on endpoint using syntax debezium-%s:name", ((EmbeddedDebeziumConfiguration)configuration).getConnectorDatabaseType()));
        }
        this.setProperties(configuration, parameters);
        if (!ObjectHelper.isEmpty((Object)remaining)) {
            ((EmbeddedDebeziumConfiguration)configuration).setName(remaining);
        }
        if (!(configurationValidation = ((EmbeddedDebeziumConfiguration)configuration).validateConfiguration()).isValid()) {
            throw new IllegalArgumentException(configurationValidation.getReason());
        }
        return this.initializeDebeziumEndpoint(uri, configuration);
    }

    protected abstract DebeziumEndpoint initializeDebeziumEndpoint(String var1, C var2);

    public abstract C getConfiguration();

    public abstract void setConfiguration(C var1);
}

