/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.embedded.spi.OffsetCommitPolicy;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.connect.json.JsonConverter;

@UriParams
public abstract class EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer";
    private Class<?> connectorClass;
    @UriPath(label="consumer")
    @Metadata(required=true)
    private String name;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.storage.FileOffsetBackingStore")
    private String offsetStorage = DebeziumConstants.DEFAULT_OFFSET_STORAGE;
    @UriParam(label="consumer")
    private String offsetStorageFileName;
    @UriParam(label="consumer")
    private String offsetStorageTopic;
    @UriParam(label="consumer")
    private int offsetStoragePartitions;
    @UriParam(label="consumer")
    private int offsetStorageReplicationFactor;
    @UriParam(label="consumer", defaultValue="io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy")
    private String offsetCommitPolicy = OffsetCommitPolicy.PeriodicCommitOffsetPolicy.class.getName();
    @UriParam(label="consumer", defaultValue="60000")
    private long offsetFlushIntervalMs = 60000L;
    @UriParam(label="consumer", defaultValue="5000")
    private long offsetCommitTimeoutMs = 5000L;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.json.JsonConverter")
    private String internalKeyConverter = JsonConverter.class.getName();
    @UriParam(label="consumer", defaultValue="org.apache.kafka.connect.json.JsonConverter")
    private String internalValueConverter = JsonConverter.class.getName();

    public EmbeddedDebeziumConfiguration() {
        ObjectHelper.notNull(this.configureConnectorClass(), (String)"connectorClass");
        this.connectorClass = this.configureConnectorClass();
    }

    protected abstract Class<?> configureConnectorClass();

    protected abstract Configuration createConnectorConfiguration();

    protected abstract ConfigurationValidation validateConnectorConfiguration();

    public abstract String getConnectorDatabaseType();

    public Configuration createDebeziumConfiguration() {
        Configuration connectorConfiguration = this.createConnectorConfiguration();
        ObjectHelper.notNull((Object)connectorConfiguration, (String)"createConnectorConfiguration");
        return ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(this.createDebeziumEmbeddedEngineConfiguration())).with(this.createConnectorConfiguration())).build();
    }

    private Configuration createDebeziumEmbeddedEngineConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.ENGINE_NAME, this.name);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.CONNECTOR_CLASS, this.connectorClass.getName());
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE, this.offsetStorage);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_FILE_FILENAME, this.offsetStorageFileName);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_TOPIC, this.offsetStorageTopic);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_PARTITIONS, Integer.valueOf(this.offsetStoragePartitions));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR, Integer.valueOf(this.offsetStorageReplicationFactor));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_COMMIT_POLICY, this.offsetCommitPolicy);
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, Long.valueOf(this.offsetFlushIntervalMs));
        EmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, EmbeddedEngine.OFFSET_COMMIT_TIMEOUT_MS, Long.valueOf(this.offsetCommitTimeoutMs));
        if (this.internalKeyConverter != null && this.internalValueConverter != null) {
            configBuilder.with("internal.key.converter", this.internalKeyConverter);
            configBuilder.with("internal.value.converter", this.internalValueConverter);
        }
        return configBuilder.build();
    }

    protected static <T> void addPropertyIfNotNull(Configuration.Builder configBuilder, Field field, T value) {
        if (value != null) {
            configBuilder.with(field, value);
        }
    }

    protected static <T> void addPropertyIfNotNull(Configuration.Builder configBuilder, String key, T value) {
        if (value != null) {
            configBuilder.with(key, value);
        }
    }

    public ConfigurationValidation validateConfiguration() {
        ConfigurationValidation embeddedEngineValidation = this.validateDebeziumEmbeddedEngineConfiguration();
        if (embeddedEngineValidation.isValid()) {
            ConfigurationValidation connectorValidation = this.validateConnectorConfiguration();
            ObjectHelper.notNull((Object)connectorValidation, (String)"validateConnectorConfiguration");
            return connectorValidation;
        }
        return embeddedEngineValidation;
    }

    private ConfigurationValidation validateDebeziumEmbeddedEngineConfiguration() {
        if (EmbeddedDebeziumConfiguration.isFieldValueNotSet(this.name)) {
            return ConfigurationValidation.notValid("Required field 'name' must be set.");
        }
        if (this.offsetStorage.equals(DebeziumConstants.DEFAULT_OFFSET_STORAGE) && EmbeddedDebeziumConfiguration.isFieldValueNotSet(this.offsetStorageFileName)) {
            return ConfigurationValidation.notValid(String.format("Required field 'offsetStorageFileName' must be set since 'offsetStorage' is set to '%s'", DebeziumConstants.DEFAULT_OFFSET_STORAGE));
        }
        return ConfigurationValidation.valid();
    }

    protected static boolean isFieldValueNotSet(Object field) {
        return ObjectHelper.isEmpty((Object)field);
    }

    public Class<?> getConnectorClass() {
        return this.connectorClass;
    }

    public void setConnectorClass(Class<?> connectorClass) {
        this.connectorClass = connectorClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOffsetStorage() {
        return this.offsetStorage;
    }

    public void setOffsetStorage(String offsetStorage) {
        this.offsetStorage = offsetStorage;
    }

    public String getOffsetStorageFileName() {
        return this.offsetStorageFileName;
    }

    public void setOffsetStorageFileName(String offsetStorageFileName) {
        this.offsetStorageFileName = offsetStorageFileName;
    }

    public String getOffsetStorageTopic() {
        return this.offsetStorageTopic;
    }

    public void setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
    }

    public int getOffsetStorageReplicationFactor() {
        return this.offsetStorageReplicationFactor;
    }

    public void setOffsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
        this.offsetStorageReplicationFactor = offsetStorageReplicationFactor;
    }

    public String getOffsetCommitPolicy() {
        return this.offsetCommitPolicy;
    }

    public void setOffsetCommitPolicy(String offsetCommitPolicy) {
        this.offsetCommitPolicy = offsetCommitPolicy;
    }

    public long getOffsetFlushIntervalMs() {
        return this.offsetFlushIntervalMs;
    }

    public void setOffsetFlushIntervalMs(long offsetFlushIntervalMs) {
        this.offsetFlushIntervalMs = offsetFlushIntervalMs;
    }

    public long getOffsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public void setOffsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
        this.offsetCommitTimeoutMs = offsetCommitTimeoutMs;
    }

    public int getOffsetStoragePartitions() {
        return this.offsetStoragePartitions;
    }

    public void setOffsetStoragePartitions(int offsetStoragePartitions) {
        this.offsetStoragePartitions = offsetStoragePartitions;
    }

    public String getInternalKeyConverter() {
        return this.internalKeyConverter;
    }

    public void setInternalKeyConverter(String internalKeyConverter) {
        this.internalKeyConverter = internalKeyConverter;
    }

    public String getInternalValueConverter() {
        return this.internalValueConverter;
    }

    public void setInternalValueConverter(String internalValueConverter) {
        this.internalValueConverter = internalValueConverter;
    }
}

