/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DebeziumMySqlEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "debezium-mysql".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "name", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(99);
        props.add("databaseJdbcDriver");
        props.add("snapshotDelayMs");
        props.add("snapshotLockingMode");
        props.add("databaseSslTruststorePassword");
        props.add("converters");
        props.add("heartbeatIntervalMs");
        props.add("decimalHandlingMode");
        props.add("skippedOperations");
        props.add("sourceStructVersion");
        props.add("binaryHandlingMode");
        props.add("bigintUnsignedHandlingMode");
        props.add("databaseHostname");
        props.add("snapshotSelectStatementOverrides");
        props.add("databaseIncludeList");
        props.add("gtidSourceFilterDmlEvents");
        props.add("columnBlacklist");
        props.add("snapshotFetchSize");
        props.add("offsetStoragePartitions");
        props.add("databaseExcludeList");
        props.add("additionalProperties");
        props.add("heartbeatActionQuery");
        props.add("databasePort");
        props.add("databaseUser");
        props.add("snapshotIncludeCollectionList");
        props.add("databaseHistory");
        props.add("includeQuery");
        props.add("databaseHistoryStoreOnlyCapturedTablesDdl");
        props.add("transactionTopic");
        props.add("includeSchemaChanges");
        props.add("internalValueConverter");
        props.add("retriableRestartConnectorWaitMs");
        props.add("sanitizeFieldNames");
        props.add("tableWhitelist");
        props.add("tableIgnoreBuiltin");
        props.add("signalDataCollection");
        props.add("connectTimeoutMs");
        props.add("databaseServerName");
        props.add("tableBlacklist");
        props.add("databaseSslKeystore");
        props.add("tableExcludeList");
        props.add("offsetCommitPolicy");
        props.add("incrementalSnapshotChunkSize");
        props.add("columnExcludeList");
        props.add("gtidSourceIncludes");
        props.add("connectKeepAliveIntervalMs");
        props.add("databasePassword");
        props.add("includeSchemaComments");
        props.add("maxBatchSize");
        props.add("internalKeyConverter");
        props.add("offsetStorageTopic");
        props.add("databaseSslMode");
        props.add("bridgeErrorHandler");
        props.add("datatypePropagateSourceType");
        props.add("provideTransactionMetadata");
        props.add("tombstonesOnDelete");
        props.add("databaseHistoryKafkaBootstrapServers");
        props.add("enableTimeAdjuster");
        props.add("heartbeatTopicsPrefix");
        props.add("databaseHistoryKafkaRecoveryPollIntervalMs");
        props.add("databaseHistorySkipUnparseableDdl");
        props.add("databaseSslKeystorePassword");
        props.add("eventProcessingFailureHandlingMode");
        props.add("offsetCommitTimeoutMs");
        props.add("databaseServerId");
        props.add("minRowCountToStreamResults");
        props.add("offsetFlushIntervalMs");
        props.add("offsetStorageFileName");
        props.add("name");
        props.add("eventDeserializationFailureHandlingMode");
        props.add("offsetStorageReplicationFactor");
        props.add("databaseInitialStatements");
        props.add("exceptionHandler");
        props.add("databaseHistoryFileFilename");
        props.add("columnPropagateSourceType");
        props.add("offsetStorage");
        props.add("inconsistentSchemaHandlingMode");
        props.add("snapshotMaxThreads");
        props.add("maxQueueSize");
        props.add("messageKeyColumns");
        props.add("timePrecisionMode");
        props.add("columnWhitelist");
        props.add("pollIntervalMs");
        props.add("databaseHistoryKafkaTopic");
        props.add("databaseHistoryStoreOnlyMonitoredTablesDdl");
        props.add("exchangePattern");
        props.add("incrementalSnapshotAllowSchemaChanges");
        props.add("gtidSourceExcludes");
        props.add("databaseSslTruststore");
        props.add("connectKeepAlive");
        props.add("queryFetchSize");
        props.add("snapshotMode");
        props.add("snapshotNewTables");
        props.add("maxQueueSizeInBytes");
        props.add("snapshotLockTimeoutMs");
        props.add("tableIncludeList");
        props.add("columnIncludeList");
        props.add("binlogBufferSize");
        props.add("databaseServerIdOffset");
        props.add("databaseHistoryKafkaRecoveryAttempts");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("additionalProperties.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

