/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class PostgresConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,postgres";
    @UriParam(label="consumer,postgres", defaultValue="none")
    private String snapshotLockingMode = "none";
    @UriParam(label="consumer,postgres")
    private String messageKeyColumns;
    @UriParam(label="consumer,postgres")
    private String customMetricTags;
    @UriParam(label="consumer,postgres", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,postgres", defaultValue="dbz_publication")
    private String publicationName = "dbz_publication";
    @UriParam(label="consumer,postgres")
    private String schemaIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="source")
    private String signalEnabledChannels = "source";
    @UriParam(label="consumer,postgres", defaultValue="6")
    private int slotMaxRetries = 6;
    @UriParam(label="consumer,postgres", defaultValue="columns_diff")
    private String schemaRefreshMode = "columns_diff";
    @UriParam(label="consumer,postgres", defaultValue="prefer")
    private String databaseSslmode = "prefer";
    @UriParam(label="consumer,postgres", defaultValue="__debezium_unavailable_value")
    private String unavailableValuePlaceholder = "__debezium_unavailable_value";
    @UriParam(label="consumer,postgres")
    private String heartbeatActionQuery;
    @UriParam(label="consumer,postgres")
    private String replicaIdentityAutosetValues;
    @UriParam(label="consumer,postgres")
    private String databaseSslcert;
    @UriParam(label="consumer,postgres", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,postgres")
    private String signalDataCollection;
    @UriParam(label="consumer,postgres")
    private String databaseInitialStatements;
    @UriParam(label="consumer,postgres", defaultValue="numeric")
    private String intervalHandlingMode = "numeric";
    @UriParam(label="consumer,postgres")
    private String converters;
    @UriParam(label="consumer,postgres", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,postgres")
    private String databaseSslfactory;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private int statusUpdateIntervalMs = 10000;
    @UriParam(label="consumer,postgres")
    private int snapshotFetchSize;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,postgres")
    private String databaseUser;
    @UriParam(label="consumer,postgres")
    private String databaseDbname;
    @UriParam(label="consumer,postgres")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,postgres")
    private String databaseSslkey;
    @UriParam(label="consumer,postgres", defaultValue="disabled")
    private String snapshotTablesOrderByRowCount = "disabled";
    @UriParam(label="consumer,postgres", defaultValue="INSERT_INSERT")
    private String incrementalSnapshotWatermarkingStrategy = "INSERT_INSERT";
    @UriParam(label="consumer,postgres")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnSchemaError = false;
    @UriParam(label="consumer,postgres")
    private String columnIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="decoderbufs")
    private String pluginName = "decoderbufs";
    @UriParam(label="consumer,postgres")
    private String databaseSslpassword;
    @UriParam(label="consumer,postgres")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,postgres", defaultValue="-1")
    private int errorsMaxRetries = -1;
    @UriParam(label="consumer,postgres")
    private String tableExcludeList;
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,postgres")
    private String databaseSslrootcert;
    @UriParam(label="consumer,postgres", defaultValue="t")
    private String skippedOperations = "t";
    @UriParam(label="consumer,postgres", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,postgres", defaultValue="io.debezium.schema.SchemaTopicNamingStrategy")
    private String topicNamingStrategy = "io.debezium.schema.SchemaTopicNamingStrategy";
    @UriParam(label="consumer,postgres", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,postgres")
    private String messagePrefixIncludeList;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotData = false;
    @UriParam(label="consumer,postgres", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,postgres", defaultValue="debezium")
    private String slotName = "debezium";
    @UriParam(label="consumer,postgres", defaultValue="1024")
    private int incrementalSnapshotChunkSize = 1024;
    @UriParam(label="consumer,postgres", defaultValue="json")
    private String hstoreHandlingMode = "json";
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,postgres")
    private String snapshotLockingModeCustomName;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,postgres", defaultValue="select_all")
    private String snapshotQueryMode = "select_all";
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnDataError = false;
    @UriParam(label="consumer,postgres")
    private String schemaHistoryInternalFileFilename;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String topicPrefix;
    @UriParam(label="consumer,postgres", defaultValue="10s", javaType="java.time.Duration")
    private long slotRetryDelayMs = 10000L;
    @UriParam(label="consumer,postgres", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,postgres", defaultValue="bytes")
    private String binaryHandlingMode = "bytes";
    @UriParam(label="consumer,postgres")
    private String snapshotQueryModeCustomName;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean includeSchemaComments = false;
    @UriParam(label="consumer,postgres", defaultValue="io.debezium.connector.postgresql.PostgresSourceInfoStructMaker")
    private String sourceinfoStructMaker = "io.debezium.connector.postgresql.PostgresSourceInfoStructMaker";
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean flushLsnSource = true;
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean databaseTcpkeepalive = true;
    @UriParam(label="consumer,postgres")
    private String schemaExcludeList;
    @UriParam(label="consumer,postgres", defaultValue="all_tables")
    private String publicationAutocreateMode = "all_tables";
    @UriParam(label="consumer,postgres")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedStartStream = false;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean slotDropOnStop = false;
    @UriParam(label="consumer,postgres", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,postgres", defaultValue="0ms", javaType="java.time.Duration")
    private long xminFetchIntervalMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotSchema = false;
    @UriParam(label="consumer,postgres", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,postgres")
    private String messagePrefixExcludeList;
    @UriParam(label="consumer,postgres", defaultValue="5s", javaType="java.time.Duration")
    private long signalPollIntervalMs = 5000L;
    @UriParam(label="consumer,postgres")
    private String postProcessors;
    @UriParam(label="consumer,postgres")
    private String notificationEnabledChannels;
    @UriParam(label="consumer,postgres", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,postgres", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,postgres", defaultValue="5432")
    private int databasePort = 5432;
    @UriParam(label="consumer,postgres")
    private String notificationSinkTopicName;
    @UriParam(label="consumer,postgres")
    private String snapshotModeCustomName;
    @UriParam(label="consumer,postgres")
    private String columnExcludeList;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean includeUnknownDatatypes = false;
    @UriParam(label="consumer,postgres")
    private String databaseHostname;
    @UriParam(label="consumer,postgres", defaultValue="none")
    private String schemaNameAdjustmentMode = "none";
    @UriParam(label="consumer,postgres")
    private String tableIncludeList;
    @UriParam(label="consumer,postgres")
    private String slotStreamParams;

    public void setSnapshotLockingMode(String snapshotLockingMode) {
        this.snapshotLockingMode = snapshotLockingMode;
    }

    public String getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setCustomMetricTags(String customMetricTags) {
        this.customMetricTags = customMetricTags;
    }

    public String getCustomMetricTags() {
        return this.customMetricTags;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setPublicationName(String publicationName) {
        this.publicationName = publicationName;
    }

    public String getPublicationName() {
        return this.publicationName;
    }

    public void setSchemaIncludeList(String schemaIncludeList) {
        this.schemaIncludeList = schemaIncludeList;
    }

    public String getSchemaIncludeList() {
        return this.schemaIncludeList;
    }

    public void setSignalEnabledChannels(String signalEnabledChannels) {
        this.signalEnabledChannels = signalEnabledChannels;
    }

    public String getSignalEnabledChannels() {
        return this.signalEnabledChannels;
    }

    public void setSlotMaxRetries(int slotMaxRetries) {
        this.slotMaxRetries = slotMaxRetries;
    }

    public int getSlotMaxRetries() {
        return this.slotMaxRetries;
    }

    public void setSchemaRefreshMode(String schemaRefreshMode) {
        this.schemaRefreshMode = schemaRefreshMode;
    }

    public String getSchemaRefreshMode() {
        return this.schemaRefreshMode;
    }

    public void setDatabaseSslmode(String databaseSslmode) {
        this.databaseSslmode = databaseSslmode;
    }

    public String getDatabaseSslmode() {
        return this.databaseSslmode;
    }

    public void setUnavailableValuePlaceholder(String unavailableValuePlaceholder) {
        this.unavailableValuePlaceholder = unavailableValuePlaceholder;
    }

    public String getUnavailableValuePlaceholder() {
        return this.unavailableValuePlaceholder;
    }

    public void setHeartbeatActionQuery(String heartbeatActionQuery) {
        this.heartbeatActionQuery = heartbeatActionQuery;
    }

    public String getHeartbeatActionQuery() {
        return this.heartbeatActionQuery;
    }

    public void setReplicaIdentityAutosetValues(String replicaIdentityAutosetValues) {
        this.replicaIdentityAutosetValues = replicaIdentityAutosetValues;
    }

    public String getReplicaIdentityAutosetValues() {
        return this.replicaIdentityAutosetValues;
    }

    public void setDatabaseSslcert(String databaseSslcert) {
        this.databaseSslcert = databaseSslcert;
    }

    public String getDatabaseSslcert() {
        return this.databaseSslcert;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setDatabaseInitialStatements(String databaseInitialStatements) {
        this.databaseInitialStatements = databaseInitialStatements;
    }

    public String getDatabaseInitialStatements() {
        return this.databaseInitialStatements;
    }

    public void setIntervalHandlingMode(String intervalHandlingMode) {
        this.intervalHandlingMode = intervalHandlingMode;
    }

    public String getIntervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setDatabaseSslfactory(String databaseSslfactory) {
        this.databaseSslfactory = databaseSslfactory;
    }

    public String getDatabaseSslfactory() {
        return this.databaseSslfactory;
    }

    public void setStatusUpdateIntervalMs(int statusUpdateIntervalMs) {
        this.statusUpdateIntervalMs = statusUpdateIntervalMs;
    }

    public int getStatusUpdateIntervalMs() {
        return this.statusUpdateIntervalMs;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setDatabaseSslkey(String databaseSslkey) {
        this.databaseSslkey = databaseSslkey;
    }

    public String getDatabaseSslkey() {
        return this.databaseSslkey;
    }

    public void setSnapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
        this.snapshotTablesOrderByRowCount = snapshotTablesOrderByRowCount;
    }

    public String getSnapshotTablesOrderByRowCount() {
        return this.snapshotTablesOrderByRowCount;
    }

    public void setIncrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
        this.incrementalSnapshotWatermarkingStrategy = incrementalSnapshotWatermarkingStrategy;
    }

    public String getIncrementalSnapshotWatermarkingStrategy() {
        return this.incrementalSnapshotWatermarkingStrategy;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
        this.snapshotModeConfigurationBasedSnapshotOnSchemaError = snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnSchemaError() {
        return this.snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setDatabaseSslpassword(String databaseSslpassword) {
        this.databaseSslpassword = databaseSslpassword;
    }

    public String getDatabaseSslpassword() {
        return this.databaseSslpassword;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setErrorsMaxRetries(int errorsMaxRetries) {
        this.errorsMaxRetries = errorsMaxRetries;
    }

    public int getErrorsMaxRetries() {
        return this.errorsMaxRetries;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabaseSslrootcert(String databaseSslrootcert) {
        this.databaseSslrootcert = databaseSslrootcert;
    }

    public String getDatabaseSslrootcert() {
        return this.databaseSslrootcert;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setTopicNamingStrategy(String topicNamingStrategy) {
        this.topicNamingStrategy = topicNamingStrategy;
    }

    public String getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setMessagePrefixIncludeList(String messagePrefixIncludeList) {
        this.messagePrefixIncludeList = messagePrefixIncludeList;
    }

    public String getMessagePrefixIncludeList() {
        return this.messagePrefixIncludeList;
    }

    public void setSnapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
        this.snapshotModeConfigurationBasedSnapshotData = snapshotModeConfigurationBasedSnapshotData;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotData() {
        return this.snapshotModeConfigurationBasedSnapshotData;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public void setIncrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
        this.incrementalSnapshotChunkSize = incrementalSnapshotChunkSize;
    }

    public int getIncrementalSnapshotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public void setHstoreHandlingMode(String hstoreHandlingMode) {
        this.hstoreHandlingMode = hstoreHandlingMode;
    }

    public String getHstoreHandlingMode() {
        return this.hstoreHandlingMode;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotLockingModeCustomName(String snapshotLockingModeCustomName) {
        this.snapshotLockingModeCustomName = snapshotLockingModeCustomName;
    }

    public String getSnapshotLockingModeCustomName() {
        return this.snapshotLockingModeCustomName;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setSnapshotQueryMode(String snapshotQueryMode) {
        this.snapshotQueryMode = snapshotQueryMode;
    }

    public String getSnapshotQueryMode() {
        return this.snapshotQueryMode;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
        this.snapshotModeConfigurationBasedSnapshotOnDataError = snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnDataError() {
        return this.snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public void setSchemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
        this.schemaHistoryInternalFileFilename = schemaHistoryInternalFileFilename;
    }

    public String getSchemaHistoryInternalFileFilename() {
        return this.schemaHistoryInternalFileFilename;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setSlotRetryDelayMs(long slotRetryDelayMs) {
        this.slotRetryDelayMs = slotRetryDelayMs;
    }

    public long getSlotRetryDelayMs() {
        return this.slotRetryDelayMs;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setBinaryHandlingMode(String binaryHandlingMode) {
        this.binaryHandlingMode = binaryHandlingMode;
    }

    public String getBinaryHandlingMode() {
        return this.binaryHandlingMode;
    }

    public void setSnapshotQueryModeCustomName(String snapshotQueryModeCustomName) {
        this.snapshotQueryModeCustomName = snapshotQueryModeCustomName;
    }

    public String getSnapshotQueryModeCustomName() {
        return this.snapshotQueryModeCustomName;
    }

    public void setIncludeSchemaComments(boolean includeSchemaComments) {
        this.includeSchemaComments = includeSchemaComments;
    }

    public boolean isIncludeSchemaComments() {
        return this.includeSchemaComments;
    }

    public void setSourceinfoStructMaker(String sourceinfoStructMaker) {
        this.sourceinfoStructMaker = sourceinfoStructMaker;
    }

    public String getSourceinfoStructMaker() {
        return this.sourceinfoStructMaker;
    }

    public void setFlushLsnSource(boolean flushLsnSource) {
        this.flushLsnSource = flushLsnSource;
    }

    public boolean isFlushLsnSource() {
        return this.flushLsnSource;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setDatabaseTcpkeepalive(boolean databaseTcpkeepalive) {
        this.databaseTcpkeepalive = databaseTcpkeepalive;
    }

    public boolean isDatabaseTcpkeepalive() {
        return this.databaseTcpkeepalive;
    }

    public void setSchemaExcludeList(String schemaExcludeList) {
        this.schemaExcludeList = schemaExcludeList;
    }

    public String getSchemaExcludeList() {
        return this.schemaExcludeList;
    }

    public void setPublicationAutocreateMode(String publicationAutocreateMode) {
        this.publicationAutocreateMode = publicationAutocreateMode;
    }

    public String getPublicationAutocreateMode() {
        return this.publicationAutocreateMode;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setSnapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
        this.snapshotModeConfigurationBasedStartStream = snapshotModeConfigurationBasedStartStream;
    }

    public boolean isSnapshotModeConfigurationBasedStartStream() {
        return this.snapshotModeConfigurationBasedStartStream;
    }

    public void setSlotDropOnStop(boolean slotDropOnStop) {
        this.slotDropOnStop = slotDropOnStop;
    }

    public boolean isSlotDropOnStop() {
        return this.slotDropOnStop;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setXminFetchIntervalMs(long xminFetchIntervalMs) {
        this.xminFetchIntervalMs = xminFetchIntervalMs;
    }

    public long getXminFetchIntervalMs() {
        return this.xminFetchIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
        this.snapshotModeConfigurationBasedSnapshotSchema = snapshotModeConfigurationBasedSnapshotSchema;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotSchema() {
        return this.snapshotModeConfigurationBasedSnapshotSchema;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setMessagePrefixExcludeList(String messagePrefixExcludeList) {
        this.messagePrefixExcludeList = messagePrefixExcludeList;
    }

    public String getMessagePrefixExcludeList() {
        return this.messagePrefixExcludeList;
    }

    public void setSignalPollIntervalMs(long signalPollIntervalMs) {
        this.signalPollIntervalMs = signalPollIntervalMs;
    }

    public long getSignalPollIntervalMs() {
        return this.signalPollIntervalMs;
    }

    public void setPostProcessors(String postProcessors) {
        this.postProcessors = postProcessors;
    }

    public String getPostProcessors() {
        return this.postProcessors;
    }

    public void setNotificationEnabledChannels(String notificationEnabledChannels) {
        this.notificationEnabledChannels = notificationEnabledChannels;
    }

    public String getNotificationEnabledChannels() {
        return this.notificationEnabledChannels;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setNotificationSinkTopicName(String notificationSinkTopicName) {
        this.notificationSinkTopicName = notificationSinkTopicName;
    }

    public String getNotificationSinkTopicName() {
        return this.notificationSinkTopicName;
    }

    public void setSnapshotModeCustomName(String snapshotModeCustomName) {
        this.snapshotModeCustomName = snapshotModeCustomName;
    }

    public String getSnapshotModeCustomName() {
        return this.snapshotModeCustomName;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setIncludeUnknownDatatypes(boolean includeUnknownDatatypes) {
        this.includeUnknownDatatypes = includeUnknownDatatypes;
    }

    public boolean isIncludeUnknownDatatypes() {
        return this.includeUnknownDatatypes;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    public void setSlotStreamParams(String slotStreamParams) {
        this.slotStreamParams = slotStreamParams;
    }

    public String getSlotStreamParams() {
        return this.slotStreamParams;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.locking.mode", (Object)this.snapshotLockingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.key.columns", (Object)this.messageKeyColumns);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"custom.metric.tags", (Object)this.customMetricTags);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"query.fetch.size", (Object)this.queryFetchSize);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"publication.name", (Object)this.publicationName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.include.list", (Object)this.schemaIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.enabled.channels", (Object)this.signalEnabledChannels);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"slot.max.retries", (Object)this.slotMaxRetries);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.refresh.mode", (Object)this.schemaRefreshMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslmode", (Object)this.databaseSslmode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"unavailable.value.placeholder", (Object)this.unavailableValuePlaceholder);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.action.query", (Object)this.heartbeatActionQuery);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"replica.identity.autoset.values", (Object)this.replicaIdentityAutosetValues);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslcert", (Object)this.databaseSslcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.data.collection", (Object)this.signalDataCollection);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.initial.statements", (Object)this.databaseInitialStatements);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"interval.handling.mode", (Object)this.intervalHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"converters", (Object)this.converters);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslfactory", (Object)this.databaseSslfactory);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"status.update.interval.ms", (Object)this.statusUpdateIntervalMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.lock.timeout.ms", (Object)this.snapshotLockTimeoutMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.user", (Object)this.databaseUser);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.dbname", (Object)this.databaseDbname);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"datatype.propagate.source.type", (Object)this.datatypePropagateSourceType);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslkey", (Object)this.databaseSslkey);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.tables.order.by.row.count", (Object)this.snapshotTablesOrderByRowCount);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"incremental.snapshot.watermarking.strategy", (Object)this.incrementalSnapshotWatermarkingStrategy);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.select.statement.overrides", (Object)this.snapshotSelectStatementOverrides);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.configuration.based.snapshot.on.schema.error", (Object)this.snapshotModeConfigurationBasedSnapshotOnSchemaError);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.include.list", (Object)this.columnIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"plugin.name", (Object)this.pluginName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslpassword", (Object)this.databaseSslpassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.propagate.source.type", (Object)this.columnPropagateSourceType);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"errors.max.retries", (Object)this.errorsMaxRetries);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.exclude.list", (Object)this.tableExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.password", (Object)this.databasePassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.sslrootcert", (Object)this.databaseSslrootcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"topic.naming.strategy", (Object)this.topicNamingStrategy);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.prefix.include.list", (Object)this.messagePrefixIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.configuration.based.snapshot.data", (Object)this.snapshotModeConfigurationBasedSnapshotData);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"slot.name", (Object)this.slotName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"incremental.snapshot.chunk.size", (Object)this.incrementalSnapshotChunkSize);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"hstore.handling.mode", (Object)this.hstoreHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"retriable.restart.connector.wait.ms", (Object)this.retriableRestartConnectorWaitMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.locking.mode.custom.name", (Object)this.snapshotLockingModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"provide.transaction.metadata", (Object)this.provideTransactionMetadata);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.query.mode", (Object)this.snapshotQueryMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.configuration.based.snapshot.on.data.error", (Object)this.snapshotModeConfigurationBasedSnapshotOnDataError);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.history.internal.file.filename", (Object)this.schemaHistoryInternalFileFilename);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"topic.prefix", (Object)this.topicPrefix);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"slot.retry.delay.ms", (Object)this.slotRetryDelayMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"decimal.handling.mode", (Object)this.decimalHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"binary.handling.mode", (Object)this.binaryHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.query.mode.custom.name", (Object)this.snapshotQueryModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.schema.comments", (Object)this.includeSchemaComments);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"sourceinfo.struct.maker", (Object)this.sourceinfoStructMaker);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"flush.lsn.source", (Object)this.flushLsnSource);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.ignore.builtin", (Object)this.tableIgnoreBuiltin);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.tcpKeepAlive", (Object)this.databaseTcpkeepalive);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.exclude.list", (Object)this.schemaExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"publication.autocreate.mode", (Object)this.publicationAutocreateMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.include.collection.list", (Object)this.snapshotIncludeCollectionList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.configuration.based.start.stream", (Object)this.snapshotModeConfigurationBasedStartStream);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"slot.drop.on.stop", (Object)this.slotDropOnStop);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size.in.bytes", (Object)this.maxQueueSizeInBytes);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"xmin.fetch.interval.ms", (Object)this.xminFetchIntervalMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.configuration.based.snapshot.schema", (Object)this.snapshotModeConfigurationBasedSnapshotSchema);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"time.precision.mode", (Object)this.timePrecisionMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.prefix.exclude.list", (Object)this.messagePrefixExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.poll.interval.ms", (Object)this.signalPollIntervalMs);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"post.processors", (Object)this.postProcessors);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"notification.enabled.channels", (Object)this.notificationEnabledChannels);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"event.processing.failure.handling.mode", (Object)this.eventProcessingFailureHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.max.threads", (Object)this.snapshotMaxThreads);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.port", (Object)this.databasePort);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"notification.sink.topic.name", (Object)this.notificationSinkTopicName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode.custom.name", (Object)this.snapshotModeCustomName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.exclude.list", (Object)this.columnExcludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.unknown.datatypes", (Object)this.includeUnknownDatatypes);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.hostname", (Object)this.databaseHostname);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.name.adjustment.mode", (Object)this.schemaNameAdjustmentMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.include.list", (Object)this.tableIncludeList);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"slot.stream.params", (Object)this.slotStreamParams);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return PostgresConnector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databasePassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'databasePassword' must be set.");
        }
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.topicPrefix)) {
            return ConfigurationValidation.notValid((String)"Required field 'topicPrefix' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "postgres";
    }
}

