/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2.api;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.dhis2.api.RootJunctionEnum;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.operation.GetOperation;

public class Dhis2Get {
    private final Dhis2Client dhis2Client;

    public Dhis2Get(Dhis2Client dhis2Client) {
        this.dhis2Client = dhis2Client;
    }

    public InputStream resource(String path, String fields, String filter, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        GetOperation getOperation = this.newGetOperation(path, fields, filter, rootJunction, queryParams);
        return ((Dhis2Response)getOperation.withParameter("paging", "false").transfer()).read();
    }

    protected GetOperation newGetOperation(String path, String fields, String filter, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        GetOperation getOperation = this.dhis2Client.get(path, new String[0]);
        if (fields != null) {
            getOperation.withFields(fields);
        }
        if (filter != null) {
            getOperation.withFilter(filter);
        }
        if (rootJunction != null) {
            if (rootJunction.equals((Object)RootJunctionEnum.AND)) {
                getOperation.withAndRootJunction();
            } else {
                getOperation.withOrRootJunction();
            }
        }
        if (queryParams != null) {
            for (Map.Entry<String, Object> queryParam : queryParams.entrySet()) {
                if (queryParam.getValue() instanceof List) {
                    for (String queryValue : (List)queryParam.getValue()) {
                        getOperation.withParameter(queryParam.getKey(), queryValue);
                    }
                    continue;
                }
                getOperation.withParameter(queryParam.getKey(), (String)queryParam.getValue());
            }
        }
        return getOperation;
    }

    public <T> Iterator<T> collection(String path, String itemType, Boolean paging, String fields, String filter, RootJunctionEnum rootJunction, Map<String, Object> queryParams) {
        Iterable iterable;
        GetOperation getOperation = this.newGetOperation(path, fields, filter, rootJunction, queryParams);
        Object iteratorDhis2Response = paging == null || paging != false ? getOperation.withPaging().transfer() : getOperation.withoutPaging().transfer();
        if (itemType == null) {
            iterable = iteratorDhis2Response.returnAs(Map.class, path);
        } else {
            try {
                iterable = iteratorDhis2Response.returnAs(Class.forName(itemType), path);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return iterable.iterator();
    }
}

