/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Snapshot;
import com.myjeeva.digitalocean.pojo.Snapshots;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.constants.DigitalOceanSnapshotTypes;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanSnapshotsProducer
extends DigitalOceanProducer {
    public DigitalOceanSnapshotsProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getSnapshots(exchange);
                break;
            }
            case get: {
                this.getSnapshot(exchange);
                break;
            }
            case delete: {
                this.deleteSnapshot(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getSnapshots(Exchange exchange) throws Exception {
        DigitalOceanSnapshotTypes type = (DigitalOceanSnapshotTypes)((Object)exchange.getIn().getHeader("CamelDigitalOceanType", DigitalOceanSnapshotTypes.class));
        Snapshots snapshots = ObjectHelper.isNotEmpty((Object)((Object)type)) ? (type == DigitalOceanSnapshotTypes.droplet ? this.getEndpoint().getDigitalOceanClient().getAllDropletSnapshots(this.configuration.getPage(), this.configuration.getPerPage()) : this.getEndpoint().getDigitalOceanClient().getAllVolumeSnapshots(this.configuration.getPage(), this.configuration.getPerPage())) : this.getEndpoint().getDigitalOceanClient().getAvailableSnapshots(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Snapshots : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), snapshots.getSnapshots()});
        exchange.getMessage().setBody((Object)snapshots.getSnapshots());
    }

    private void getSnapshot(Exchange exchange) throws Exception {
        String snapshotId = (String)exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty((Object)snapshotId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Snapshot snapshot = this.getEndpoint().getDigitalOceanClient().getSnaphotInfo(snapshotId);
        LOG.trace("Snapshot [{}] ", (Object)snapshot);
        exchange.getMessage().setBody((Object)snapshot);
    }

    private void deleteSnapshot(Exchange exchange) throws Exception {
        String snapshotId = (String)exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty((Object)snapshotId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Delete delete = this.getEndpoint().getDigitalOceanClient().deleteSnapshot(snapshotId);
        LOG.trace("Delete Snapshot [{}] ", (Object)delete);
        exchange.getMessage().setBody((Object)delete);
    }
}

