/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.FloatingIP;
import com.myjeeva.digitalocean.pojo.FloatingIPs;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanFloatingIPsProducer
extends DigitalOceanProducer {
    public DigitalOceanFloatingIPsProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getFloatingIPs(exchange);
                break;
            }
            case create: {
                this.createFloatingIp(exchange);
                break;
            }
            case get: {
                this.getFloatingIP(exchange);
                break;
            }
            case delete: {
                this.deleteFloatingIP(exchange);
                break;
            }
            case assign: {
                this.assignFloatingIPToDroplet(exchange);
                break;
            }
            case unassign: {
                this.unassignFloatingIP(exchange);
                break;
            }
            case listActions: {
                this.getFloatingIPActions(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createFloatingIp(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        FloatingIP ip;
        Integer dropletId = (Integer)exchange.getIn().getHeader("CamelDigitalOceanDropletId", Integer.class);
        String region = (String)exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isNotEmpty((Object)dropletId)) {
            ip = this.getEndpoint().getDigitalOceanClient().createFloatingIP(dropletId);
        } else if (ObjectHelper.isNotEmpty((Object)region)) {
            ip = this.getEndpoint().getDigitalOceanClient().createFloatingIP(region);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanDropletId or CamelDigitalOceanRegion must be specified");
        }
        LOG.trace("FloatingIP [{}] ", (Object)ip);
        exchange.getMessage().setBody((Object)ip);
    }

    private void getFloatingIPs(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        FloatingIPs ips = this.getEndpoint().getDigitalOceanClient().getAvailableFloatingIPs(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Floating IPs : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), ips.getFloatingIPs()});
        exchange.getMessage().setBody((Object)ips.getFloatingIPs());
    }

    private void getFloatingIP(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String ipAddress = (String)exchange.getIn().getHeader("CamelDigitalOceanFloatingIPAddress", String.class);
        if (ObjectHelper.isEmpty((Object)ipAddress)) {
            throw new IllegalArgumentException("CamelDigitalOceanFloatingIPAddress must be specified");
        }
        FloatingIP ip = this.getEndpoint().getDigitalOceanClient().getFloatingIPInfo(ipAddress);
        LOG.trace("Floating IP {}", (Object)ip);
        exchange.getMessage().setBody((Object)ip);
    }

    private void deleteFloatingIP(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String ipAddress = (String)exchange.getIn().getHeader("CamelDigitalOceanFloatingIPAddress", String.class);
        if (ObjectHelper.isEmpty((Object)ipAddress)) {
            throw new IllegalArgumentException("CamelDigitalOceanFloatingIPAddress must be specified");
        }
        Delete delete = this.getEndpoint().getDigitalOceanClient().deleteFloatingIP(ipAddress);
        LOG.trace("Delete Floating IP {}", (Object)delete);
        exchange.getMessage().setBody((Object)delete);
    }

    private void assignFloatingIPToDroplet(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer dropletId = (Integer)exchange.getIn().getHeader("CamelDigitalOceanDropletId", Integer.class);
        if (ObjectHelper.isEmpty((Object)dropletId)) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletId must be specified");
        }
        String ipAddress = (String)exchange.getIn().getHeader("CamelDigitalOceanFloatingIPAddress", String.class);
        if (ObjectHelper.isEmpty((Object)ipAddress)) {
            throw new IllegalArgumentException("CamelDigitalOceanFloatingIPAddress must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().assignFloatingIP(dropletId, ipAddress);
        LOG.trace("Assign Floating IP to Droplet {}", (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void unassignFloatingIP(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String ipAddress = (String)exchange.getIn().getHeader("CamelDigitalOceanFloatingIPAddress", String.class);
        if (ObjectHelper.isEmpty((Object)ipAddress)) {
            throw new IllegalArgumentException("CamelDigitalOceanFloatingIPAddress must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().unassignFloatingIP(ipAddress);
        LOG.trace("Unassign Floating IP {}", (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void getFloatingIPActions(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String ipAddress = (String)exchange.getIn().getHeader("CamelDigitalOceanFloatingIPAddress", String.class);
        if (ObjectHelper.isEmpty((Object)ipAddress)) {
            throw new IllegalArgumentException("CamelDigitalOceanFloatingIPAddress must be specified");
        }
        Actions actions = this.getEndpoint().getDigitalOceanClient().getAvailableFloatingIPActions(ipAddress, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Actions for FloatingIP {} : page {} / {} per page [{}] ", new Object[]{ipAddress, this.configuration.getPage(), this.configuration.getPerPage(), actions.getActions()});
        exchange.getMessage().setBody((Object)actions.getActions());
    }
}

