/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectProducer.class);
    private static final String ACTIVE_SPAN_PROPERTY = "OpenTracing.activeSpan";
    private static final String CLOSE_CLIENT_SCOPE = "OpenTracing.closeClientScope";
    private volatile DirectConsumer consumer;
    private int stateCounter;
    private final DirectEndpoint endpoint;
    private final DirectComponent component;
    private final String key;
    private final boolean block;
    private final long timeout;

    public DirectProducer(DirectEndpoint endpoint, String key) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.component = (DirectComponent)endpoint.getComponent();
        this.key = key;
        this.block = endpoint.isBlock();
        this.timeout = endpoint.getTimeout();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.consumer == null || this.stateCounter != this.component.getStateCounter()) {
            this.stateCounter = this.component.getStateCounter();
            this.consumer = this.component.getConsumer(this.key, this.block, this.timeout);
        }
        if (this.consumer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new DirectConsumerNotAvailableException("No consumers available on endpoint: " + String.valueOf((Object)this.endpoint), exchange);
            }
            LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
        } else {
            this.consumer.getProcessor().process(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.endpoint.isSynchronous()) {
                this.process(exchange);
                callback.done(true);
                return true;
            }
            if (this.consumer == null || this.stateCounter != this.component.getStateCounter()) {
                this.stateCounter = this.component.getStateCounter();
                this.consumer = this.component.getConsumer(this.key, this.block, this.timeout);
            }
            if (this.consumer == null) {
                if (this.endpoint.isFailIfNoConsumers()) {
                    exchange.setException((Throwable)((Object)new DirectConsumerNotAvailableException("No consumers available on endpoint: " + String.valueOf((Object)this.endpoint), exchange)));
                } else {
                    LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
                }
                callback.done(true);
                return true;
            }
            if (this.consumer.getEndpoint().isSynchronous()) {
                this.consumer.getProcessor().process(exchange);
                callback.done(true);
                return true;
            }
            if (exchange.getProperty(ACTIVE_SPAN_PROPERTY) != null) {
                exchange.setProperty(CLOSE_CLIENT_SCOPE, (Object)Boolean.TRUE);
            }
            return this.consumer.getAsyncProcessor().process(exchange, callback);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while processing the exchange");
            Thread.currentThread().interrupt();
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }
}

