/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="direct-vm")
public class DirectVmComponent
extends DefaultComponent {
    private static final AtomicInteger START_COUNTER = new AtomicInteger();
    private static final ConcurrentMap<String, DirectVmConsumer> CONSUMERS = new ConcurrentHashMap<String, DirectVmConsumer>();
    @Metadata(label="producer", defaultValue="true")
    private boolean block = true;
    @Metadata(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @Metadata(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @Metadata(label="advanced", defaultValue="true")
    private boolean propagateProperties = true;

    public static Collection<Endpoint> getConsumerEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(CONSUMERS.size());
        for (DirectVmConsumer consumer : CONSUMERS.values()) {
            endpoints.add((Endpoint)consumer.getEndpoint());
        }
        return endpoints;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DirectVmEndpoint answer = new DirectVmEndpoint(uri, this);
        answer.setBlock(this.block);
        answer.setTimeout(this.timeout);
        answer.setPropagateProperties(this.propagateProperties);
        answer.configureProperties(parameters);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    public DirectVmConsumer getConsumer(DirectVmEndpoint endpoint) {
        String key = DirectVmComponent.getConsumerKey(endpoint.getEndpointUri());
        return (DirectVmConsumer)((Object)CONSUMERS.get(key));
    }

    public void addConsumer(DirectVmEndpoint endpoint, DirectVmConsumer consumer) {
        String key = DirectVmComponent.getConsumerKey(endpoint.getEndpointUri());
        DirectVmConsumer existing = CONSUMERS.putIfAbsent(key, consumer);
        if (existing != null) {
            String contextId = existing.getEndpoint().getCamelContext().getName();
            throw new IllegalStateException("A consumer " + (Object)((Object)existing) + " already exists from CamelContext: " + contextId + ". Multiple consumers not supported");
        }
    }

    public void removeConsumer(DirectVmEndpoint endpoint, DirectVmConsumer consumer) {
        String key = DirectVmComponent.getConsumerKey(endpoint.getEndpointUri());
        CONSUMERS.remove(key);
    }

    private static String getConsumerKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    protected void doStop() throws Exception {
        if (START_COUNTER.decrementAndGet() <= 0) {
            CONSUMERS.clear();
        }
        super.doStop();
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isPropagateProperties() {
        return this.propagateProperties;
    }

    public void setPropagateProperties(boolean propagateProperties) {
        this.propagateProperties = propagateProperties;
    }
}

