/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.zoo.ModelNotFoundException;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.apache.camel.component.djl.model.CustomImageClassificationPredictor;
import org.apache.camel.component.djl.model.CustomObjectDetectionPredictor;
import org.apache.camel.component.djl.model.ZooImageClassificationPredictor;
import org.apache.camel.component.djl.model.ZooObjectDetectionPredictor;

public final class ModelPredictorProducer {
    private ModelPredictorProducer() {
    }

    public static AbstractPredictor getZooPredictor(String applicationPath, String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        if (applicationPath.equals(Application.CV.IMAGE_CLASSIFICATION.getPath())) {
            return new ZooImageClassificationPredictor(artifactId);
        }
        if (applicationPath.equals(Application.CV.OBJECT_DETECTION.getPath())) {
            return new ZooObjectDetectionPredictor(artifactId);
        }
        throw new RuntimeCamelException("Application not supported ");
    }

    public static AbstractPredictor getCustomPredictor(String applicationPath, String model, String translator) {
        if (applicationPath.equals(Application.CV.IMAGE_CLASSIFICATION.getPath())) {
            return new CustomImageClassificationPredictor(model, translator);
        }
        if (applicationPath.equals(Application.CV.OBJECT_DETECTION.getPath())) {
            return new CustomObjectDetectionPredictor(model, translator);
        }
        throw new RuntimeCamelException("Application not supported ");
    }
}

