/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomObjectDetectionPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomObjectDetectionPredictor.class);
    private final String modelName;
    private final String translatorName;

    public CustomObjectDetectionPredictor(String modelName, String translatorName) {
        this.modelName = modelName;
        this.translatorName = translatorName;
    }

    @Override
    public void process(Exchange exchange) {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        if (exchange.getIn().getBody() instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            DetectedObjects result = this.classify(model, translator, new ByteArrayInputStream(bytes));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof File) {
            DetectedObjects result = this.classify(model, translator, (File)exchange.getIn().getBody(File.class));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            DetectedObjects result = this.classify(model, translator, (InputStream)exchange.getIn().getBody(InputStream.class));
            exchange.getIn().setBody((Object)result);
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be byte[], InputStream or File");
        }
    }

    public DetectedObjects classify(Model model, Translator translator, Image image) {
        DetectedObjects detectedObjects;
        block8: {
            Predictor predictor = model.newPredictor(translator);
            try {
                detectedObjects = (DetectedObjects)predictor.predict((Object)image);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    LOG.error("Could not process input or output", (Throwable)e);
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return detectedObjects;
    }

    public DetectedObjects classify(Model model, Translator translator, File input) {
        DetectedObjects detectedObjects;
        FileInputStream fileInputStream = new FileInputStream(input);
        try {
            Image image = ImageFactory.getInstance().fromInputStream((InputStream)fileInputStream);
            detectedObjects = this.classify(model, translator, image);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Couldn't transform input into a BufferedImage");
                throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
            }
        }
        ((InputStream)fileInputStream).close();
        return detectedObjects;
    }

    public DetectedObjects classify(Model model, Translator translator, InputStream input) {
        try {
            Image image = ImageFactory.getInstance().fromInputStream(input);
            return this.classify(model, translator, image);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }
}

