/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooObjectDetectionPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(ZooObjectDetectionPredictor.class);
    private final ZooModel<Image, DetectedObjects> model;

    public ZooObjectDetectionPredictor(String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().optApplication(Application.CV.OBJECT_DETECTION).setTypes(Image.class, DetectedObjects.class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) {
        if (exchange.getIn().getBody() instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            DetectedObjects result = this.classify(new ByteArrayInputStream(bytes));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof File) {
            DetectedObjects result = this.classify((File)exchange.getIn().getBody(File.class));
            exchange.getIn().setBody((Object)result);
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            DetectedObjects result = this.classify((InputStream)exchange.getIn().getBody(InputStream.class));
            exchange.getIn().setBody((Object)result);
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be byte[], InputStream or File");
        }
    }

    public DetectedObjects classify(Image image) {
        DetectedObjects detectedObjects;
        block8: {
            Predictor predictor = this.model.newPredictor();
            try {
                DetectedObjects detectedObjects2;
                detectedObjects = detectedObjects2 = (DetectedObjects)predictor.predict((Object)image);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return detectedObjects;
    }

    public DetectedObjects classify(File input) {
        DetectedObjects detectedObjects;
        FileInputStream fileInputStream = new FileInputStream(input);
        try {
            Image image = ImageFactory.getInstance().fromInputStream((InputStream)fileInputStream);
            detectedObjects = this.classify(image);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Couldn't transform input into a BufferedImage");
                throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
            }
        }
        ((InputStream)fileInputStream).close();
        return detectedObjects;
    }

    public DetectedObjects classify(InputStream input) {
        try {
            Image image = ImageFactory.getInstance().fromInputStream(input);
            return this.classify(image);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }
}

