/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.cloud;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.dns.DnsConfiguration;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public final class DnsServiceDiscovery
extends DefaultServiceDiscovery {
    private static final Comparator<SRVRecord> COMPARATOR = DnsServiceDiscovery.comparator();
    private final DnsConfiguration configuration;
    private final ConcurrentHashMap<String, Lookup> cache;

    public DnsServiceDiscovery(DnsConfiguration configuration) {
        this.configuration = configuration;
        this.cache = new ConcurrentHashMap();
    }

    public List<ServiceDefinition> getServices(String name) {
        Lookup lookup = this.cache.computeIfAbsent(name, this::createLookup);
        Record[] records = lookup.run();
        List<Object> services = Objects.nonNull(records) && lookup.getResult() == 0 ? Arrays.stream(records).filter(SRVRecord.class::isInstance).map(SRVRecord.class::cast).sorted(COMPARATOR).map(srvRecord -> DnsServiceDiscovery.asService(name, srvRecord)).collect(Collectors.toList()) : Collections.emptyList();
        return services;
    }

    private Lookup createLookup(String name) {
        try {
            return new Lookup(String.format("%s.%s.%s", name, this.configuration.getProto(), this.configuration.getDomain()), 33);
        }
        catch (TextParseException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private static Comparator<SRVRecord> comparator() {
        Comparator byPriority = (e1, e2) -> Integer.compare(e2.getPriority(), e1.getPriority());
        Comparator byWeight = (e1, e2) -> Integer.compare(e2.getWeight(), e1.getWeight());
        return byPriority.thenComparing(byWeight);
    }

    private static ServiceDefinition asService(String serviceName, SRVRecord srvRecord) {
        HashMap meta = new HashMap();
        ObjectHelper.ifNotEmpty((Object)srvRecord.getPriority(), val -> meta.put("priority", Integer.toString(val)));
        ObjectHelper.ifNotEmpty((Object)srvRecord.getWeight(), val -> meta.put("weight", Integer.toString(val)));
        return new DefaultServiceDefinition(serviceName, srvRecord.getTarget().toString(true), srvRecord.getPort(), meta);
    }
}

