/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.consumer;

import com.github.dockerjava.api.command.EventCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEventsConsumer
extends DefaultConsumer
implements EventCallback {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DockerEventsConsumer.class);
    private DockerEndpoint endpoint;
    private DockerComponent component;
    private EventsCmd eventsCmd;
    private ExecutorService eventsExecutorService;

    public DockerEventsConsumer(DockerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public DockerEndpoint getEndpoint() {
        return (DockerEndpoint)super.getEndpoint();
    }

    private long processInitialEvent() {
        long currentTime = new Date().getTime();
        Long initialRange = DockerHelper.getProperty("CamelDockerInitialRange", this.endpoint.getConfiguration(), null, Long.class);
        if (initialRange != null) {
            currentTime -= initialRange.longValue();
        }
        return currentTime;
    }

    protected void doStart() throws Exception {
        this.eventsCmd = DockerClientFactory.getDockerClient(this.component, this.endpoint.getConfiguration(), null).eventsCmd((EventCallback)this);
        this.eventsCmd.withSince(String.valueOf(this.processInitialEvent()));
        this.eventsExecutorService = (ExecutorService)this.eventsCmd.exec();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.eventsExecutorService != null && !this.eventsExecutorService.isTerminated()) {
            LOGGER.trace("Stopping Docker events Executor Service");
            this.eventsExecutorService.shutdown();
        }
        super.doStop();
    }

    public void onEvent(Event event) {
        LOGGER.debug("Received Docker Event: " + event);
        final Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        message.setBody((Object)event);
        try {
            LOGGER.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    LOGGER.trace("Done processing exchange [{}]...", (Object)exchange);
                }
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    public void onException(Throwable throwable) {
        LOGGER.error("Error Consuming from Docker Events: {}", (Object)throwable.getMessage());
    }

    public void onCompletion(int numEvents) {
        LOGGER.debug("Docker events connection completed. Events processed : {}", (Object)numEvents);
        this.eventsCmd.withSince(null);
        LOGGER.debug("Reestablishing connection with Docker");
        this.eventsCmd.exec();
    }

    public boolean isReceiving() {
        return this.isRunAllowed();
    }
}

