/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import com.github.dockerjava.api.exception.DockerClientException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerConstants;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang.BooleanUtils;

public final class DockerHelper {
    private static final String STRING_DELIMITER = ";";

    private DockerHelper() {
    }

    public static void validateParameters(DockerOperation dockerOperation, Map<String, Object> parameters) {
        HashMap validParamMap = new HashMap();
        validParamMap.putAll(DockerConstants.DOCKER_DEFAULT_PARAMETERS);
        validParamMap.putAll(dockerOperation.getParameters());
        for (String key : parameters.keySet()) {
            String transformedKey = DockerHelper.transformToHeaderName(key);
            if (!validParamMap.containsKey(transformedKey)) {
                throw new DockerClientException(key + " is not a valid URI parameter");
            }
            try {
                Class parameterClass = (Class)validParamMap.get(transformedKey);
                Object parameterValue = parameters.get(key);
                if (parameterClass == null || parameterValue == null) {
                    throw new DockerClientException("Failed to validate parameter type for property " + key);
                }
                if (Integer.class == parameterClass) {
                    Integer.parseInt((String)parameterValue);
                    continue;
                }
                if (Boolean.class != parameterClass) continue;
                BooleanUtils.toBooleanObject((String)((String)parameterValue), (String)"true", (String)"false", (String)"null");
            }
            catch (Exception e) {
                throw new DockerClientException("Failed to validate parameter type for property " + key);
            }
        }
    }

    public static String transformFromHeaderName(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        StringBuilder formattedName = new StringBuilder();
        String nameSubstring = name.substring("CamelDocker".length());
        if (nameSubstring.length() > 0) {
            formattedName.append(nameSubstring.substring(0, 1).toLowerCase());
            formattedName.append(nameSubstring.substring(1));
        }
        return formattedName.toString();
    }

    public static String transformToHeaderName(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        StringBuilder formattedName = new StringBuilder("CamelDocker");
        if (name.length() > 0) {
            formattedName.append(name.substring(0, 1).toUpperCase());
            formattedName.append(name.substring(1));
        }
        return formattedName.toString();
    }

    public static <T> T getProperty(String name, DockerConfiguration configuration, Message message, Class<T> clazz) {
        return DockerHelper.getProperty(name, configuration, message, clazz, null);
    }

    public static <T> T getProperty(String name, DockerConfiguration configuration, Message message, Class<T> clazz, T defaultValue) {
        Object headerProperty;
        if (message != null && (headerProperty = message.getHeader(name, clazz)) != null) {
            return (T)headerProperty;
        }
        Object prop = configuration.getParameters().get(DockerHelper.transformFromHeaderName(name));
        if (prop != null) {
            if (prop.getClass().isAssignableFrom(clazz)) {
                return (T)prop;
            }
            if (Integer.class == clazz) {
                return (T)Integer.valueOf((String)prop);
            }
            if (Boolean.class == clazz) {
                return (T)BooleanUtils.toBooleanObject((String)((String)prop), (String)"true", (String)"false", (String)"null");
            }
        } else if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    public static <T> T[] getArrayProperty(String name, Message message, Class<T> clazz) {
        Object header;
        if (message != null && (header = message.getHeader(name)) != null) {
            if (header.getClass().isAssignableFrom(clazz)) {
                Object[] headerArray = (Object[])Array.newInstance(clazz, 1);
                headerArray[0] = header;
                return headerArray;
            }
            if (header.getClass().isArray() && (header.getClass().getComponentType().isAssignableFrom(clazz) || header.getClass().getDeclaringClass().isAssignableFrom(clazz))) {
                return (Object[])header;
            }
        }
        return null;
    }

    public static String[] parseDelimitedStringHeader(String headerName, Message message) {
        Object header = message.getHeader(headerName);
        if (header != null) {
            if (header instanceof String) {
                return ((String)header).split(STRING_DELIMITER);
            }
            if (header instanceof String[]) {
                return (String[])header;
            }
        }
        return null;
    }
}

