/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientProfile;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.component.docker.ssl.NoImplSslConfig;
import org.apache.camel.util.ObjectHelper;

public final class DockerClientFactory {
    private DockerClientFactory() {
    }

    public static DockerClient getDockerClient(DockerComponent dockerComponent, DockerConfiguration dockerConfiguration, Message message) throws DockerException {
        NoImplSslConfig sslConfig;
        ObjectHelper.notNull((Object)dockerConfiguration, (String)"dockerConfiguration");
        Integer port = DockerHelper.getProperty("CamelDockerPort", dockerConfiguration, message, Integer.class, dockerConfiguration.getPort());
        String host = DockerHelper.getProperty("CamelDockerHost", dockerConfiguration, message, String.class, dockerConfiguration.getHost());
        Integer maxTotalConnections = DockerHelper.getProperty("CamelDockerMaxTotalConnections", dockerConfiguration, message, Integer.class, dockerConfiguration.getMaxTotalConnections());
        Integer maxPerRouteConnections = DockerHelper.getProperty("CamelDockerMaxPerRouteConnections", dockerConfiguration, message, Integer.class, dockerConfiguration.getMaxPerRouteConnections());
        String username = DockerHelper.getProperty("CamelDockerUsername", dockerConfiguration, message, String.class, dockerConfiguration.getUsername());
        String password = DockerHelper.getProperty("CamelDockerPassword", dockerConfiguration, message, String.class, dockerConfiguration.getPassword());
        String email = DockerHelper.getProperty("CamelDockerEmail", dockerConfiguration, message, String.class, dockerConfiguration.getEmail());
        Integer requestTimeout = DockerHelper.getProperty("CamelDockerRequestTimeout", dockerConfiguration, message, Integer.class, dockerConfiguration.getRequestTimeout());
        String serverAddress = DockerHelper.getProperty("CamelDockerServerAddress", dockerConfiguration, message, String.class, dockerConfiguration.getServerAddress());
        String certPath = DockerHelper.getProperty("CamelDockerCertPath", dockerConfiguration, message, String.class, dockerConfiguration.getCertPath());
        Boolean secure = DockerHelper.getProperty("CamelDockerSecure", dockerConfiguration, message, Boolean.class, dockerConfiguration.isSecure());
        Boolean tlsVerify = DockerHelper.getProperty("CamelDockerTlsVerify", dockerConfiguration, message, Boolean.class, dockerConfiguration.isTlsVerify());
        Boolean socket = DockerHelper.getProperty("CamelDockerSocketEnabled", dockerConfiguration, message, Boolean.class, dockerConfiguration.isSocket());
        String cmdExecFactory = DockerHelper.getProperty("CamelDockerCmdExecFactory", dockerConfiguration, message, String.class, dockerConfiguration.getCmdExecFactory());
        DockerClientProfile clientProfile = new DockerClientProfile();
        clientProfile.setHost(host);
        clientProfile.setPort(port);
        clientProfile.setEmail(email);
        clientProfile.setUsername(username);
        clientProfile.setPassword(password);
        clientProfile.setRequestTimeout(requestTimeout);
        clientProfile.setServerAddress(serverAddress);
        clientProfile.setCertPath(certPath);
        clientProfile.setMaxTotalConnections(maxTotalConnections);
        clientProfile.setMaxPerRouteConnections(maxPerRouteConnections);
        clientProfile.setSecure(secure);
        clientProfile.setTlsVerify(tlsVerify);
        clientProfile.setSocket(socket);
        clientProfile.setCmdExecFactory(cmdExecFactory);
        DockerClient dockerClient = dockerComponent.getClient(clientProfile);
        if (dockerClient != null) {
            return dockerClient;
        }
        if (clientProfile.isSecure() != null && clientProfile.isSecure().booleanValue()) {
            ObjectHelper.notNull((Object)clientProfile.getCertPath(), (String)"certPath must be specified in secure mode");
            sslConfig = new LocalDirectorySSLConfig(clientProfile.getCertPath());
        } else {
            sslConfig = new NoImplSslConfig();
        }
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(clientProfile.toUrl()).withDockerTlsVerify(clientProfile.isTlsVerify()).withRegistryUsername(clientProfile.getUsername()).withRegistryPassword(clientProfile.getPassword()).withRegistryEmail(clientProfile.getEmail()).withRegistryUrl(clientProfile.getServerAddress()).withCustomSslConfig((SSLConfig)sslConfig);
        if (clientProfile.getCertPath() != null) {
            configBuilder.withDockerCertPath(clientProfile.getCertPath());
        }
        CamelContext camelContext = dockerComponent.getCamelContext();
        try {
            JerseyDockerCmdExecFactory factory = null;
            if (cmdExecFactory.equals(JerseyDockerCmdExecFactory.class.getName())) {
                factory = new JerseyDockerCmdExecFactory();
                factory.withReadTimeout(clientProfile.getRequestTimeout()).withConnectTimeout(clientProfile.getRequestTimeout()).withMaxTotalConnections(clientProfile.getMaxTotalConnections()).withMaxPerRouteConnections(clientProfile.getMaxPerRouteConnections());
            } else if (cmdExecFactory.equals(NettyDockerCmdExecFactory.class.getName())) {
                factory = new NettyDockerCmdExecFactory();
                ((NettyDockerCmdExecFactory)factory).withConnectTimeout(clientProfile.getRequestTimeout());
            } else {
                Class clazz = camelContext.getClassResolver().resolveMandatoryClass(cmdExecFactory, DockerCmdExecFactory.class);
                factory = (DockerCmdExecFactory)org.apache.camel.support.ObjectHelper.newInstance((Class)clazz);
            }
            dockerClient = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)configBuilder).withDockerCmdExecFactory((DockerCmdExecFactory)factory).build();
            dockerComponent.setClient(clientProfile, dockerClient);
            return dockerClient;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to resolve DockerCmdExecFactory class: " + cmdExecFactory, e);
        }
    }
}

