/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.consumer.DockerEventsConsumer;
import org.apache.camel.component.docker.consumer.DockerStatsConsumer;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.component.docker.producer.AsyncDockerProducer;
import org.apache.camel.component.docker.producer.DockerProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.15.0", scheme="docker", title="Docker", syntax="docker:operation", label="container,cloud,paas", lenientProperties=true)
public class DockerEndpoint
extends DefaultEndpoint {
    @UriParam
    private DockerConfiguration configuration;

    public DockerEndpoint() {
    }

    public DockerEndpoint(String uri, DockerComponent component, DockerConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        DockerOperation operation = this.configuration.getOperation();
        if (operation != null && operation.canProduce()) {
            if (operation.isAsync()) {
                return new AsyncDockerProducer(this);
            }
            return new DockerProducer(this);
        }
        throw new DockerException((Object)((Object)operation) + " is not a valid producer operation");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer;
        DockerOperation operation = this.configuration.getOperation();
        if (operation == DockerOperation.EVENTS) {
            consumer = new DockerEventsConsumer(this, processor);
        } else if (operation == DockerOperation.STATS) {
            consumer = new DockerStatsConsumer(this, processor);
        } else {
            throw new DockerException((Object)((Object)operation) + " is not a valid consumer operation");
        }
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public DockerConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isLenientProperties() {
        return true;
    }
}

