/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.producer;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.InputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProducer
extends DefaultProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerProducer.class);
    private DockerConfiguration configuration;
    private DockerComponent component;

    public DockerProducer(DockerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        DockerClient client = DockerClientFactory.getDockerClient(this.component, this.configuration, message);
        DockerOperation operation = this.configuration.getOperation();
        Object result = null;
        switch (operation) {
            case AUTH: {
                try (AuthCmd cmd = this.executeAuthRequest(client);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case INFO: {
                try (InfoCmd cmd = this.executeInfoRequest(client);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case PING: {
                try (PingCmd cmd = this.executePingRequest(client);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case VERSION: {
                try (VersionCmd cmd = this.executeVersionRequest(client);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case CREATE_IMAGE: {
                try (CreateImageCmd cmd = this.executeCreateImageRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case INSPECT_IMAGE: {
                try (InspectImageCmd cmd = this.executeInspectImageRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case LIST_IMAGES: {
                try (ListImagesCmd cmd = this.executeListImagesRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case REMOVE_IMAGE: {
                try (RemoveImageCmd cmd = this.executeRemoveImageRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case SEARCH_IMAGES: {
                try (SearchImagesCmd cmd = this.executeSearchImageRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case TAG_IMAGE: {
                try (TagImageCmd cmd = this.executeTagImageRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case COMMIT_CONTAINER: {
                try (CommitCmd cmd = this.executeCommitContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case COPY_FILE_CONTAINER: {
                try (CopyArchiveFromContainerCmd cmd = this.executeCopyFileContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case CREATE_CONTAINER: {
                try (CreateContainerCmd cmd = this.executeCreateContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case DIFF_CONTAINER: {
                try (ContainerDiffCmd cmd = this.executeDiffContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case INSPECT_CONTAINER: {
                try (InspectContainerCmd cmd = this.executeInspectContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case LIST_CONTAINERS: {
                try (ListContainersCmd cmd = this.executeListContainersRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case KILL_CONTAINER: {
                try (KillContainerCmd cmd = this.executeKillContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case PAUSE_CONTAINER: {
                try (PauseContainerCmd cmd = this.executePauseContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case REMOVE_CONTAINER: {
                try (RemoveContainerCmd cmd = this.executeRemoveContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case RESTART_CONTAINER: {
                try (RestartContainerCmd cmd = this.executeRestartContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case START_CONTAINER: {
                try (StartContainerCmd cmd = this.executeStartContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case STOP_CONTAINER: {
                try (StopContainerCmd cmd = this.executeStopContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case TOP_CONTAINER: {
                try (TopContainerCmd cmd = this.executeTopContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case UNPAUSE_CONTAINER: {
                try (UnpauseContainerCmd cmd = this.executeUnpauseContainerRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case CREATE_NETWORK: {
                try (CreateNetworkCmd cmd = this.executeCreateNetworkRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case REMOVE_NETWORK: {
                try (RemoveNetworkCmd cmd = this.executeRemoveNetworkRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case CONNECT_NETWORK: {
                try (ConnectToNetworkCmd cmd = this.executeConnectToNetworkRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            case EXEC_CREATE: {
                try (ExecCreateCmd cmd = this.executeExecCreateRequest(client, message);){
                    result = this.safeExec((SyncDockerCmd<?>)cmd);
                    break;
                }
            }
            default: {
                throw new DockerException("Invalid operation: " + operation);
            }
        }
        if (result != null) {
            exchange.getIn().setBody(result);
        }
    }

    private Object safeExec(SyncDockerCmd<?> cmd) {
        if (cmd == null) {
            LOGGER.warn("Trying to execute a docker command but the requested object is null");
            return null;
        }
        return cmd.exec();
    }

    private AuthCmd executeAuthRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Auth Request");
        AuthCmd authCmd = client.authCmd();
        if (authCmd != null) {
            AuthConfig authConfig = client.authConfig();
            authCmd.withAuthConfig(authConfig);
        }
        return authCmd;
    }

    private InfoCmd executeInfoRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Info Request");
        return client.infoCmd();
    }

    private PingCmd executePingRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Ping Request");
        return client.pingCmd();
    }

    private VersionCmd executeVersionRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Version Request");
        return client.versionCmd();
    }

    private CreateImageCmd executeCreateImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Create Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        InputStream inputStream = (InputStream)message.getBody(InputStream.class);
        if (repository == null || inputStream == null) {
            throw new IllegalArgumentException("Inputstream must be present on message body and repository must be specified");
        }
        return client.createImageCmd(repository, inputStream);
    }

    private InspectImageCmd executeInspectImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)imageId, (String)"Image ID must be specified");
        return client.inspectImageCmd(imageId);
    }

    private ListImagesCmd executeListImagesRequest(DockerClient client, Message message) {
        Boolean showAll;
        LOGGER.debug("Executing Docker Images List Request");
        ListImagesCmd listImagesCmd = client.listImagesCmd();
        String filter = DockerHelper.getProperty("CamelDockerFilter", this.configuration, message, String.class);
        if (filter != null) {
            listImagesCmd.withLabelFilter(new String[]{filter});
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listImagesCmd.withShowAll(showAll);
        }
        return listImagesCmd;
    }

    private RemoveImageCmd executeRemoveImageRequest(DockerClient client, Message message) {
        Boolean noPrune;
        LOGGER.debug("Executing Docker Remove Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)imageId, (String)"Image ID must be specified");
        RemoveImageCmd removeImagesCmd = client.removeImageCmd(imageId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeImagesCmd.withForce(force);
        }
        if ((noPrune = DockerHelper.getProperty("CamelDockerNoPrune", this.configuration, message, Boolean.class)) != null) {
            removeImagesCmd.withNoPrune(noPrune);
        }
        return removeImagesCmd;
    }

    private SearchImagesCmd executeSearchImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Search Image Request");
        String term = DockerHelper.getProperty("CamelDockerTerm", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)term, (String)"Term must be specified");
        return client.searchImagesCmd(term);
    }

    private TagImageCmd executeTagImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Tag Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (imageId == null || repository == null || tag == null) {
            throw new IllegalArgumentException("ImageId, repository and tag must be specified");
        }
        TagImageCmd tagImageCmd = client.tagImageCmd(imageId, repository, tag);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            tagImageCmd.withForce(force);
        }
        return tagImageCmd;
    }

    private CommitCmd executeCommitContainerRequest(DockerClient client, Message message) {
        String workingDir;
        Volumes volumes;
        String user;
        Boolean tty;
        String tag;
        Boolean stdInOnce;
        String repository;
        String[] portSpecs;
        Boolean pause;
        Boolean openStdIn;
        String msg;
        Integer memorySwap;
        Integer memory;
        String hostname;
        ExposedPorts exposedPorts;
        String[] envs;
        Boolean disableNetwork;
        String[] cmds;
        Boolean attachStdOut;
        Boolean attachStdIn;
        Boolean attachStdErr;
        LOGGER.debug("Executing Docker Commit Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        CommitCmd commitCmd = client.commitCmd(containerId);
        String author = DockerHelper.getProperty("CamelDockerAuthor", this.configuration, message, String.class);
        if (author != null) {
            commitCmd.withAuthor(author);
        }
        if ((attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStderr(attachStdErr);
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdout(attachStdOut);
        }
        if ((cmds = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            commitCmd.withCmd(cmds);
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withDisableNetwork(disableNetwork);
        }
        if ((envs = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            commitCmd.withEnv(envs);
        }
        if ((exposedPorts = DockerHelper.getProperty("CamelDockerExposedPorts", this.configuration, message, ExposedPorts.class)) != null) {
            commitCmd.withExposedPorts(exposedPorts);
        }
        if ((hostname = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            commitCmd.withHostname(hostname);
        }
        if ((memory = DockerHelper.getProperty("CamelDockerMemory", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemory(memory);
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemorySwap(memorySwap);
        }
        if ((msg = DockerHelper.getProperty("CamelDockerMessage", this.configuration, message, String.class)) != null) {
            commitCmd.withMessage(msg);
        }
        if ((openStdIn = DockerHelper.getProperty("CamelDockerOpenStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withOpenStdin(openStdIn);
        }
        if ((pause = DockerHelper.getProperty("CamelDockerPause", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withPause(pause);
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            commitCmd.withPortSpecs(portSpecs);
        }
        if ((repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class)) != null) {
            commitCmd.withRepository(repository);
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withStdinOnce(stdInOnce);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            commitCmd.withTag(tag);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withTty(tty);
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            commitCmd.withUser(user);
        }
        if ((volumes = DockerHelper.getProperty("CamelDockerVolumes", this.configuration, message, Volumes.class)) != null) {
            commitCmd.withVolumes(volumes);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            commitCmd.withWorkingDir(workingDir);
        }
        return commitCmd;
    }

    private CopyArchiveFromContainerCmd executeCopyFileContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Copy File/Folder Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        String resource = DockerHelper.getProperty("CamelDockerResource", this.configuration, message, String.class);
        if (containerId == null || resource == null) {
            throw new IllegalArgumentException("Container ID and Resource must be specified");
        }
        CopyArchiveFromContainerCmd copyArchiveFromContainerCmd = client.copyArchiveFromContainerCmd(containerId, resource);
        String hostPath = DockerHelper.getProperty("CamelDockerHostPath", this.configuration, message, String.class);
        if (hostPath != null) {
            copyArchiveFromContainerCmd.withHostPath(hostPath);
        }
        return copyArchiveFromContainerCmd;
    }

    private CreateContainerCmd executeCreateContainerRequest(DockerClient client, Message message) {
        String workingDir;
        VolumesFrom[] volumesFrom;
        Volume[] volume;
        String user;
        Boolean tty;
        Boolean stdInOnce;
        Boolean stdInOpen;
        String[] portSpecs;
        String name;
        Long memorySwap;
        Long memoryLimit;
        String hostName;
        HostConfig hostConfig;
        ExposedPort[] exposedPorts;
        String[] entrypoint;
        String[] env;
        String domainName;
        String[] dns;
        Boolean disableNetwork;
        Integer cpuShares;
        String[] cmd;
        Capability[] capDrop;
        Capability[] capAdd;
        Boolean attachStdOut;
        Boolean attachStdIn;
        LOGGER.debug("Executing Docker Create Container Request");
        String image = DockerHelper.getProperty("CamelDockerImage", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)image, (String)"Image must be specified");
        CreateContainerCmd createContainerCmd = client.createContainerCmd(image);
        createContainerCmd.withHostConfig(HostConfig.newHostConfig());
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            createContainerCmd.withAttachStderr(attachStdErr);
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdout(attachStdOut);
        }
        if ((capAdd = DockerHelper.getArrayProperty("CamelDockerCapAdd", message, Capability.class)) != null) {
            createContainerCmd.getHostConfig().withCapAdd(capAdd);
        }
        if ((capDrop = DockerHelper.getArrayProperty("CamelDockerCapDrop", message, Capability.class)) != null) {
            createContainerCmd.getHostConfig().withCapDrop(capDrop);
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            createContainerCmd.withCmd(cmd);
        }
        if ((cpuShares = DockerHelper.getProperty("CamelDockerCpuShares", this.configuration, message, Integer.class)) != null) {
            createContainerCmd.getHostConfig().withCpuShares(cpuShares);
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withNetworkDisabled(disableNetwork);
        }
        if ((dns = DockerHelper.parseDelimitedStringHeader("CamelDockerDns", message)) != null) {
            createContainerCmd.getHostConfig().withDns(dns);
        }
        if ((domainName = DockerHelper.getProperty("CamelDockerDomainName", this.configuration, message, String.class)) != null) {
            createContainerCmd.withDomainName(domainName);
        }
        if ((env = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            createContainerCmd.withEnv(env);
        }
        if ((entrypoint = DockerHelper.getArrayProperty("CamelDockerEntryPoint", message, String.class)) != null) {
            createContainerCmd.withEntrypoint(entrypoint);
        }
        if ((exposedPorts = DockerHelper.getArrayProperty("CamelDockerExposedPorts", message, ExposedPort.class)) != null) {
            createContainerCmd.withExposedPorts(exposedPorts);
        }
        if ((hostConfig = DockerHelper.getProperty("CamelDockerHostConfig", this.configuration, message, HostConfig.class)) != null) {
            createContainerCmd.withHostConfig(hostConfig);
        }
        if ((hostName = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            createContainerCmd.withHostName(hostName);
        }
        if ((memoryLimit = DockerHelper.getProperty("CamelDockerMemoryLimit", this.configuration, message, Long.class)) != null) {
            createContainerCmd.getHostConfig().withMemory(memoryLimit);
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Long.class)) != null) {
            createContainerCmd.getHostConfig().withMemorySwap(memorySwap);
        }
        if ((name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class)) != null) {
            createContainerCmd.withName(name);
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            createContainerCmd.withPortSpecs(portSpecs);
        }
        if ((stdInOpen = DockerHelper.getProperty("CamelDockerStdInOpen", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdinOpen(stdInOpen);
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdInOnce(stdInOnce);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withTty(tty);
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            createContainerCmd.withUser(user);
        }
        if ((volume = DockerHelper.getArrayProperty("CamelDockerVolumes", message, Volume.class)) != null) {
            createContainerCmd.withVolumes(volume);
        }
        if ((volumesFrom = DockerHelper.getArrayProperty("CamelDockerVolumesFrom", message, VolumesFrom.class)) != null) {
            createContainerCmd.getHostConfig().withVolumesFrom(volumesFrom);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            createContainerCmd.withWorkingDir(workingDir);
        }
        return createContainerCmd;
    }

    private ContainerDiffCmd executeDiffContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Diff Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        ContainerDiffCmd diffContainerCmd = client.containerDiffCmd(containerId);
        String containerIdDiff = DockerHelper.getProperty("CamelDockerContainerIdDiff", this.configuration, message, String.class);
        if (containerIdDiff != null) {
            diffContainerCmd.withContainerId(containerIdDiff);
        }
        return diffContainerCmd;
    }

    private InspectContainerCmd executeInspectContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.inspectContainerCmd(containerId);
    }

    private KillContainerCmd executeKillContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Kill Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        KillContainerCmd killContainerCmd = client.killContainerCmd(containerId);
        String signal = DockerHelper.getProperty("CamelDockerSignal", this.configuration, message, String.class);
        if (signal != null) {
            killContainerCmd.withSignal(signal);
        }
        return killContainerCmd;
    }

    private ListContainersCmd executeListContainersRequest(DockerClient client, Message message) {
        String since;
        Boolean showSize;
        Boolean showAll;
        Integer limit;
        LOGGER.debug("Executing Docker List Container Request");
        ListContainersCmd listContainersCmd = client.listContainersCmd();
        String before = DockerHelper.getProperty("CamelDockerBefore", this.configuration, message, String.class);
        if (before != null) {
            listContainersCmd.withBefore(before);
        }
        if ((limit = DockerHelper.getProperty("CamelDockerLimit", this.configuration, message, Integer.class)) != null) {
            listContainersCmd.withLimit(limit);
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowAll(showAll);
        }
        if ((showSize = DockerHelper.getProperty("CamelDockerShowSize", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowSize(showSize);
        }
        if ((since = DockerHelper.getProperty("CamelDockerSince", this.configuration, message, String.class)) != null) {
            listContainersCmd.withSince(since);
        }
        return listContainersCmd;
    }

    private PauseContainerCmd executePauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Pause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.pauseContainerCmd(containerId);
    }

    private RemoveContainerCmd executeRemoveContainerRequest(DockerClient client, Message message) {
        Boolean removeVolumes;
        LOGGER.debug("Executing Docker Remove Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        RemoveContainerCmd removeContainerCmd = client.removeContainerCmd(containerId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeContainerCmd.withForce(force);
        }
        if ((removeVolumes = DockerHelper.getProperty("CamelDockerRemoveVolumes", this.configuration, message, Boolean.class)) != null) {
            removeContainerCmd.withRemoveVolumes(removeVolumes);
        }
        return removeContainerCmd;
    }

    private RestartContainerCmd executeRestartContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Restart Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        RestartContainerCmd restartContainerCmd = client.restartContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            restartContainerCmd.withtTimeout(timeout);
        }
        return restartContainerCmd;
    }

    private StartContainerCmd executeStartContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Start Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.startContainerCmd(containerId);
    }

    private StopContainerCmd executeStopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Stop Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        StopContainerCmd stopContainerCmd = client.stopContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            stopContainerCmd.withTimeout(timeout);
        }
        return stopContainerCmd;
    }

    private TopContainerCmd executeTopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Top Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        TopContainerCmd topContainerCmd = client.topContainerCmd(containerId);
        String psArgs = DockerHelper.getProperty("CamelDockerPsArgs", this.configuration, message, String.class);
        if (psArgs != null) {
            topContainerCmd.withPsArgs(psArgs);
        }
        return topContainerCmd;
    }

    private UnpauseContainerCmd executeUnpauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Unpause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.unpauseContainerCmd(containerId);
    }

    private CreateNetworkCmd executeCreateNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Create Request");
        String networkName = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)networkName, (String)"Network Name must be specified");
        return client.createNetworkCmd().withName(networkName);
    }

    private RemoveNetworkCmd executeRemoveNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Remove Request");
        String networkId = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)networkId, (String)"Network ID must be specified");
        return client.removeNetworkCmd(networkId);
    }

    private ConnectToNetworkCmd executeConnectToNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Connect Request");
        String networkId = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)networkId, (String)"Network ID must be specified");
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        return client.connectToNetworkCmd().withNetworkId(networkId).withContainerId(containerId);
    }

    private ExecCreateCmd executeExecCreateRequest(DockerClient client, Message message) {
        Boolean tty;
        String[] cmd;
        Boolean attachStdOut;
        LOGGER.debug("Executing Docker Exec Create Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        ExecCreateCmd execCreateCmd = client.execCreateCmd(containerId);
        Boolean attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class);
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            execCreateCmd.withAttachStderr(attachStdErr);
        }
        if (attachStdIn != null) {
            execCreateCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withAttachStdout(attachStdOut);
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            execCreateCmd.withCmd(cmd);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withTty(tty);
        }
        return execCreateCmd;
    }
}

