/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import com.github.dockerjava.api.DockerClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.docker.DockerClientProfile;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="docker")
public class DockerComponent
extends DefaultComponent {
    private Map<DockerClientProfile, DockerClient> clients = new HashMap<DockerClientProfile, DockerClient>();
    @Metadata
    private DockerConfiguration configuration = new DockerConfiguration();

    public DockerComponent() {
    }

    public DockerComponent(DockerConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DockerConfiguration configuration = this.getConfiguration().copy();
        String normalizedRemaining = remaining.replace("/", "");
        DockerOperation operation = DockerOperation.getDockerOperation(normalizedRemaining);
        if (operation == null) {
            throw new DockerException(remaining + " is not a valid operation");
        }
        configuration.setOperation(operation);
        DockerEndpoint endpoint = new DockerEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        configuration.setParameters(parameters);
        return endpoint;
    }

    public void setConfiguration(DockerConfiguration configuration) {
        this.configuration = configuration;
    }

    public DockerConfiguration getConfiguration() {
        return this.configuration;
    }

    public DockerClient getClient(DockerClientProfile clientProfile) throws DockerException {
        return this.clients.get(clientProfile);
    }

    public void setClient(DockerClientProfile clientProfile, DockerClient client) {
        this.clients.put(clientProfile, client);
    }
}

