/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.consumer;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.model.Statistics;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerStatsConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DockerStatsConsumer.class);
    private DockerEndpoint endpoint;
    private DockerComponent component;
    private StatsCmd statsCmd;

    public DockerStatsConsumer(DockerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public DockerEndpoint getEndpoint() {
        return (DockerEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.endpoint.getConfiguration(), null, String.class);
        this.statsCmd = DockerClientFactory.getDockerClient(this.component, this.endpoint.getConfiguration(), null).statsCmd(containerId);
        this.statsCmd.exec((ResultCallback)new StatsCallback());
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.statsCmd.close();
        super.doStop();
    }

    protected class StatsCallback
    extends ResultCallbackTemplate<StatsCallback, Statistics> {
        protected StatsCallback() {
        }

        public void onNext(Statistics statistics) {
            LOGGER.debug("Received Docker Statistics Event: {}", (Object)statistics);
            final Exchange exchange = DockerStatsConsumer.this.getEndpoint().createExchange();
            Message message = exchange.getIn();
            message.setBody((Object)statistics);
            try {
                LOGGER.trace("Processing exchange [{}]...", (Object)exchange);
                DockerStatsConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        LOGGER.trace("Done processing exchange [{}]...", (Object)exchange);
                    }
                });
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                DockerStatsConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

