/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.dozer.BaseConverter;
import org.apache.camel.spi.ClassResolver;

public class CustomMapper
extends BaseConverter {
    private ClassResolver resolver;

    public CustomMapper(ClassResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        try {
            Object object = this.mapCustom(sourceFieldValue, sourceClass);
            return object;
        }
        finally {
            this.done();
        }
    }

    private Object invokeFunction(Method method, Object customObj, Object source, String[][] parameters) throws Exception {
        Class<?>[] prmTypes = method.getParameterTypes();
        Object[] methodPrms = new Object[prmTypes.length];
        methodPrms[0] = source;
        int parameterNdx = 0;
        int methodPrmNdx = 1;
        while (parameterNdx < parameters.length) {
            if (method.isVarArgs() && methodPrmNdx == prmTypes.length - 1) {
                Object array = Array.newInstance(prmTypes[methodPrmNdx].getComponentType(), parameters.length - parameterNdx);
                int arrayNdx = 0;
                while (parameterNdx < parameters.length) {
                    String[] parts = parameters[parameterNdx];
                    Array.set(array, arrayNdx, this.resolver.resolveClass(parts[0]).getConstructor(String.class).newInstance(parts[1]));
                    ++parameterNdx;
                    ++arrayNdx;
                }
                methodPrms[methodPrmNdx] = array;
            } else {
                String[] parts = parameters[parameterNdx];
                methodPrms[methodPrmNdx] = this.resolver.resolveClass(parts[0]).getConstructor(String.class).newInstance(parts[1]);
            }
            ++parameterNdx;
            ++methodPrmNdx;
        }
        return method.invoke(customObj, methodPrms);
    }

    Object mapCustom(Object source, Class<?> sourceClass) {
        Method method;
        Object customObj;
        String[][] prmTypesAndValues;
        String operation;
        String[] prms = this.getParameter().split(",");
        String className = prms[0];
        String string = operation = prms.length > 1 ? prms[1] : null;
        if (prms.length > 2) {
            prmTypesAndValues = new String[prms.length - 2][2];
            for (int ndx = 0; ndx < prmTypesAndValues.length; ++ndx) {
                String prm = prms[ndx + 2];
                String[] parts = prm.split("=");
                if (parts.length != 2) {
                    throw new RuntimeCamelException("Value missing for parameter " + prm);
                }
                prmTypesAndValues[ndx][0] = parts[0];
                prmTypesAndValues[ndx][1] = parts[1];
            }
        } else {
            prmTypesAndValues = null;
        }
        try {
            Class customClass = this.resolver.resolveMandatoryClass(className);
            customObj = customClass.newInstance();
            method = operation != null && prmTypesAndValues != null ? this.selectMethod(customClass, operation, sourceClass, prmTypesAndValues) : (operation != null ? customClass.getMethod(operation, sourceClass) : this.selectMethod(customClass, sourceClass));
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to load custom function", (Throwable)e);
        }
        if (method == null) {
            throw new RuntimeCamelException("No eligible custom function methods in " + className);
        }
        try {
            if (prmTypesAndValues != null) {
                return this.invokeFunction(method, customObj, source, prmTypesAndValues);
            }
            return method.invoke(customObj, source);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error while invoking custom function", (Throwable)e);
        }
    }

    private boolean parametersMatchParameterList(Class<?>[] prmTypes, String[][] parameters) {
        for (int ndx = 0; ndx < prmTypes.length; ++ndx) {
            Class<?> prmType = prmTypes[ndx];
            if (ndx >= parameters.length) {
                return ndx == prmTypes.length - 1 && prmType.isArray();
            }
            if (ndx == prmTypes.length - 1 && prmType.isArray()) {
                Class<?> varArgClass = prmType.getComponentType();
                while (ndx < parameters.length) {
                    Class prmClass = this.resolver.resolveClass(parameters[ndx][0]);
                    if (!varArgClass.isAssignableFrom(prmClass)) {
                        return false;
                    }
                    ++ndx;
                }
                continue;
            }
            Class prmClass = this.resolver.resolveClass(parameters[ndx][0]);
            if (prmTypes[ndx].isAssignableFrom(prmClass)) continue;
            return false;
        }
        return true;
    }

    Method selectMethod(Class<?> customClass, Class<?> sourceClass) {
        Method method = null;
        for (Method m : customClass.getDeclaredMethods()) {
            if (m.getReturnType() == null || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(sourceClass)) continue;
            method = m;
            break;
        }
        return method;
    }

    private Method selectMethod(Class<?> customClass, String operation, Class<?> sourceClass, String[][] parameters) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : customClass.getDeclaredMethods()) {
            methods.add(method);
        }
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            Class<?>[] prmTypes = method.getParameterTypes();
            if (!method.getName().equals(operation) || method.getReturnType() == null || !prmTypes[0].isAssignableFrom(sourceClass)) {
                iter.remove();
                continue;
            }
            prmTypes = Arrays.copyOfRange(prmTypes, 1, prmTypes.length);
            if (!method.isVarArgs() && prmTypes.length != parameters.length) {
                iter.remove();
                continue;
            }
            if (this.parametersMatchParameterList(prmTypes, parameters)) continue;
            iter.remove();
        }
        if (methods.size() > 1) {
            for (Method method : methods) {
                if (method.isVarArgs()) continue;
                return method;
            }
        }
        return !methods.isEmpty() ? (Method)methods.get(0) : null;
    }
}

