/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.core;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchResult;
import com.dropbox.core.v2.files.WriteMode;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.dto.DropboxFileUploadResult;
import org.apache.camel.component.dropbox.dto.DropboxMoveResult;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxResultCode;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.util.IOHelper;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropboxAPIFacade {
    private static final Logger LOG = LoggerFactory.getLogger(DropboxAPIFacade.class);
    private final DbxClientV2 client;
    private final Exchange exchange;

    public DropboxAPIFacade(DbxClientV2 client, Exchange exchange) {
        this.client = client;
        this.exchange = exchange;
    }

    public DropboxFileUploadResult put(String localPath, String remotePath, DropboxUploadMode mode) throws DropboxException {
        String dropboxPath = remotePath == null ? localPath : remotePath;
        boolean isPresent = true;
        try {
            this.client.files().getMetadata(dropboxPath);
        }
        catch (DbxException e) {
            isPresent = false;
        }
        if (localPath != null) {
            return this.putFile(localPath, mode, dropboxPath, isPresent);
        }
        return this.putBody(this.exchange, mode, dropboxPath, isPresent);
    }

    private DropboxFileUploadResult putFile(String localPath, DropboxUploadMode mode, String dropboxPath, boolean isPresent) throws DropboxException {
        File fileLocalPath = new File(localPath);
        if (fileLocalPath.isFile()) {
            DropboxFileUploadResult result;
            if (isPresent && !DropboxUploadMode.force.equals((Object)mode)) {
                throw new DropboxException(dropboxPath + " exists on dropbox. Use force upload mode to override");
            }
            if (!isPresent && dropboxPath.endsWith("/")) {
                dropboxPath = dropboxPath + fileLocalPath.getName();
            }
            LOG.debug("Uploading: {},{}", (Object)fileLocalPath, (Object)dropboxPath);
            try {
                FileMetadata uploadedFile = this.putSingleFile(fileLocalPath, dropboxPath, mode);
                result = uploadedFile == null ? new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO) : new DropboxFileUploadResult(dropboxPath, DropboxResultCode.OK);
            }
            catch (Exception ex) {
                result = new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO);
            }
            return result;
        }
        if (fileLocalPath.isDirectory()) {
            LOG.debug("Uploading a dir...");
            if (isPresent && !DropboxUploadMode.force.equals((Object)mode)) {
                throw new DropboxException(dropboxPath + " exists on dropbox and is not a folder!");
            }
            if (!dropboxPath.endsWith("/")) {
                dropboxPath = dropboxPath + "/";
            }
            String oldDropboxPath = dropboxPath;
            Collection listFiles = FileUtils.listFiles((File)fileLocalPath, null, (boolean)true);
            if (listFiles.isEmpty()) {
                throw new DropboxException(localPath + " does not contain any files");
            }
            HashMap<String, DropboxResultCode> resultMap = new HashMap<String, DropboxResultCode>(listFiles.size());
            for (File file : listFiles) {
                String absPath = file.getAbsolutePath();
                int indexRemainingPath = localPath.length();
                if (!localPath.endsWith("/")) {
                    ++indexRemainingPath;
                }
                String remainingPath = absPath.substring(indexRemainingPath);
                dropboxPath = dropboxPath + remainingPath;
                try {
                    LOG.debug("Uploading: {},{}", (Object)fileLocalPath, (Object)dropboxPath);
                    FileMetadata uploadedFile = this.putSingleFile(file, dropboxPath, mode);
                    if (uploadedFile == null) {
                        resultMap.put(dropboxPath, DropboxResultCode.KO);
                    } else {
                        resultMap.put(dropboxPath, DropboxResultCode.OK);
                    }
                }
                catch (Exception ex) {
                    resultMap.put(dropboxPath, DropboxResultCode.KO);
                }
                dropboxPath = oldDropboxPath;
            }
            return new DropboxFileUploadResult(resultMap);
        }
        return null;
    }

    private DropboxFileUploadResult putBody(Exchange exchange, DropboxUploadMode mode, String dropboxPath, boolean isPresent) {
        DropboxFileUploadResult result;
        String name = (String)exchange.getIn().getHeader("CamelDropboxPutFileName", String.class);
        if (name == null) {
            name = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        }
        if (name == null) {
            name = exchange.getIn().getMessageId();
        }
        if (!isPresent && dropboxPath.endsWith("/")) {
            dropboxPath = dropboxPath + name;
        }
        LOG.debug("Uploading message body: {}", (Object)dropboxPath);
        try {
            FileMetadata uploadedFile = this.putSingleBody(exchange, dropboxPath, mode);
            result = uploadedFile == null ? new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO) : new DropboxFileUploadResult(dropboxPath, DropboxResultCode.OK);
        }
        catch (Exception ex) {
            result = new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMetadata putSingleFile(File inputFile, String dropboxPath, DropboxUploadMode mode) throws Exception {
        FileInputStream inputStream = new FileInputStream(inputFile);
        try {
            FileMetadata uploadedFile;
            WriteMode uploadMode = mode == DropboxUploadMode.force ? WriteMode.OVERWRITE : WriteMode.ADD;
            FileMetadata fileMetadata = uploadedFile = (FileMetadata)this.client.files().uploadBuilder(dropboxPath).withMode(uploadMode).uploadAndFinish((InputStream)inputStream, inputFile.length());
            return fileMetadata;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMetadata putSingleBody(Exchange exchange, String dropboxPath, DropboxUploadMode mode) throws Exception {
        byte[] data = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            FileMetadata uploadedFile;
            WriteMode uploadMode = mode == DropboxUploadMode.force ? WriteMode.OVERWRITE : WriteMode.ADD;
            FileMetadata fileMetadata = uploadedFile = (FileMetadata)this.client.files().uploadBuilder(dropboxPath).withMode(uploadMode).uploadAndFinish((InputStream)is, (long)data.length);
            return fileMetadata;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    public DropboxSearchResult search(String remotePath, String query) throws DropboxException {
        if (query == null) {
            LOG.debug("Search no query");
            try {
                SearchResult listing = this.client.files().search(remotePath, null);
                List searchMatches = listing.getMatches();
                return new DropboxSearchResult(searchMatches);
            }
            catch (DbxException e) {
                throw new DropboxException(remotePath + " does not exist or cannot obtain metadata", e);
            }
        }
        LOG.debug("Search by query: {}", (Object)query);
        try {
            SearchResult listing = this.client.files().search(remotePath, query);
            List searchMatches = listing.getMatches();
            return new DropboxSearchResult(searchMatches);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or cannot obtain metadata", e);
        }
    }

    public DropboxDelResult del(String remotePath) throws DropboxException {
        try {
            this.client.files().deleteV2(remotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or cannot obtain metadata", e);
        }
        return new DropboxDelResult(remotePath);
    }

    public DropboxMoveResult move(String remotePath, String newRemotePath) throws DropboxException {
        try {
            this.client.files().moveV2(remotePath, newRemotePath);
            return new DropboxMoveResult(remotePath, newRemotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or cannot obtain metadata", e);
        }
    }

    public DropboxFileDownloadResult get(String remotePath) throws DropboxException {
        return new DropboxFileDownloadResult(this.downloadFilesInFolder(remotePath));
    }

    private Map<String, Object> downloadFilesInFolder(String path) throws DropboxException {
        try {
            ListFolderResult folderResult = this.client.files().listFolder(path.equals("/") ? "" : path);
            LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
            for (Metadata entry : folderResult.getEntries()) {
                returnMap.put(entry.getPathDisplay(), this.downloadSingleFile(entry.getPathDisplay()).getValue());
            }
            return returnMap;
        }
        catch (ListFolderErrorException e) {
            try {
                DbxDownloader listing = this.client.files().download(path);
                if (listing == null) {
                    return Collections.emptyMap();
                }
                LOG.debug("downloading a single file...");
                Map.Entry<String, Object> entry = this.downloadSingleFile(path);
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            catch (DbxException dbxException) {
                throw new DropboxException(dbxException);
            }
        }
        catch (DbxException e) {
            throw new DropboxException(e);
        }
    }

    private Map.Entry<String, Object> downloadSingleFile(String path) throws DropboxException {
        try {
            OutputStreamBuilder target = OutputStreamBuilder.withExchange((Exchange)this.exchange);
            DbxDownloader downloadedFile = this.client.files().download(path);
            if (downloadedFile != null) {
                downloadedFile.download((OutputStream)target);
                LOG.debug("downloaded path={}", (Object)path);
                return new AbstractMap.SimpleEntry<String, Object>(path, target.build());
            }
            return null;
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or cannot obtain metadata", e);
        }
        catch (IOException e) {
            throw new DropboxException(path + " cannot obtain a stream", e);
        }
    }
}

