/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxConstants;
import org.apache.camel.component.dropbox.util.DropboxHelper;
import org.apache.camel.component.dropbox.validator.DropboxConfigurationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxGetProducer
extends DropboxProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxGetProducer.class);

    public DropboxGetProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        String remotePath = DropboxHelper.getRemotePath(this.configuration, exchange);
        DropboxConfigurationValidator.validateGetOp(remotePath);
        DropboxFileDownloadResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).get(remotePath);
        Map<String, Object> map = result.getEntries();
        if (map.size() == 1) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                exchange.getIn().setHeader(DropboxConstants.DOWNLOADED_FILE, (Object)entry.getKey());
                exchange.getIn().setBody(entry.getValue());
            }
        } else {
            StringBuilder pathsExtracted = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                pathsExtracted.append(entry.getKey()).append("\n");
            }
            exchange.getIn().setHeader(DropboxConstants.DOWNLOADED_FILES, (Object)pathsExtracted.toString());
            exchange.getIn().setBody(map);
        }
        LOG.debug("Downloaded: {}", (Object)result);
    }
}

