/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.consumer;

import com.dropbox.core.v2.files.SearchMatch;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollConsumer;
import org.apache.camel.component.dropbox.util.DropboxConstants;

public class DropboxScheduledPollSearchConsumer
extends DropboxScheduledPollConsumer {
    public DropboxScheduledPollSearchConsumer(DropboxEndpoint endpoint, Processor processor, DropboxConfiguration configuration) {
        super(endpoint, processor, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        Exchange exchange = this.createExchange(false);
        try {
            DropboxSearchResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).search(this.configuration.getRemotePath(), this.configuration.getQuery());
            StringBuilder fileExtracted = new StringBuilder();
            for (SearchMatch entry : result.getFound()) {
                fileExtracted.append(entry.getMetadata().getName()).append("-").append(entry.getMetadata().getPathDisplay()).append("\n");
            }
            exchange.getIn().setHeader(DropboxConstants.FOUND_FILES, (Object)fileExtracted.toString());
            exchange.getIn().setBody(result.getFound());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Downloaded: {}", (Object)result);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
            this.releaseExchange(exchange, false);
        }
    }
}

