/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox;

import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.v2.DbxClientV2;
import org.apache.camel.component.dropbox.util.DropboxOperation;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DropboxConfiguration {
    @UriPath
    @Metadata(required=true)
    private DropboxOperation operation;
    @UriParam
    @Metadata(label="security", required=true, secret=true)
    private String accessToken;
    @UriParam
    @Metadata(label="security", required=true, secret=true)
    private Long expireIn;
    @UriParam
    @Metadata(label="security", required=true, secret=true)
    private String refreshToken;
    @UriParam
    @Metadata(label="security", required=true, secret=true)
    private String apiKey;
    @UriParam
    @Metadata(label="security", required=true, secret=true)
    private String apiSecret;
    @UriParam(label="producer")
    private String localPath;
    @UriParam(label="common")
    private String remotePath;
    @UriParam(label="producer")
    private String newRemotePath;
    @UriParam(label="common")
    private String query;
    @UriParam(label="producer")
    private DropboxUploadMode uploadMode;
    @UriParam(label="common")
    private String clientIdentifier;
    @UriParam(label="advanced")
    private DbxClientV2 client;

    public void setClient(DbxClientV2 client) {
        this.client = client;
    }

    public DbxClientV2 getClient() {
        return this.client;
    }

    public void createClient() {
        DbxRequestConfig config = DbxRequestConfig.newBuilder((String)this.clientIdentifier).build();
        DbxCredential credential = new DbxCredential(this.accessToken, this.expireIn, this.refreshToken, this.apiKey, this.apiSecret);
        this.client = new DbxClientV2(config, credential);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public Long getExpireIn() {
        return this.expireIn;
    }

    public void setExpireIn(Long expireIn) {
        this.expireIn = expireIn;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getNewRemotePath() {
        return this.newRemotePath;
    }

    public void setNewRemotePath(String newRemotePath) {
        this.newRemotePath = newRemotePath;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    public DropboxOperation getOperation() {
        return this.operation;
    }

    public void setOperation(DropboxOperation operation) {
        this.operation = operation;
    }

    public DropboxUploadMode getUploadMode() {
        return this.uploadMode;
    }

    public void setUploadMode(DropboxUploadMode uploadMode) {
        this.uploadMode = uploadMode;
    }
}

