/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.support;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StartupStep;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteBuilderLifecycleStrategy;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.RoutesBuilderLoaderSupport;
import org.apache.camel.util.IOHelper;

public abstract class RouteBuilderLoaderSupport
extends RoutesBuilderLoaderSupport {
    private final String extension;
    private final List<CompilePostProcessor> compilePostProcessors = new ArrayList<CompilePostProcessor>();
    private StartupStepRecorder recorder;

    protected RouteBuilderLoaderSupport(String extension) {
        this.extension = extension;
    }

    @ManagedAttribute(description="Supported file extension")
    public String getSupportedExtension() {
        return this.extension;
    }

    public List<CompilePostProcessor> getCompilePostProcessors() {
        return this.compilePostProcessors;
    }

    public void addCompilePostProcessor(CompilePostProcessor preProcessor) {
        this.compilePostProcessors.add(preProcessor);
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.getCamelContext() != null) {
            this.recorder = this.getCamelContext().getCamelContextExtension().getStartupStepRecorder();
        }
    }

    protected void doStart() throws Exception {
        Set pres;
        super.doStart();
        if (this.getCamelContext() != null && (pres = this.getCamelContext().getRegistry().findByType(CompilePostProcessor.class)) != null && !pres.isEmpty()) {
            for (CompilePostProcessor pre : pres) {
                this.addCompilePostProcessor(pre);
            }
        }
    }

    public RoutesBuilder loadRoutesBuilder(Resource resource) throws Exception {
        RouteBuilder builder = this.doLoadRouteBuilder(resource);
        if (builder != null) {
            CamelContextAware.trySetCamelContext((Object)builder, (CamelContext)this.getCamelContext());
            builder.setResource(resource);
            if (this.recorder != null) {
                final StartupStep step = this.recorder.beginStep(((Object)((Object)this)).getClass(), resource.getLocation(), "Loading route from: " + resource.getLocation());
                builder.addLifecycleInterceptor(new RouteBuilderLifecycleStrategy(){

                    public void afterConfigure(RouteBuilder builder) {
                        step.endStep();
                    }
                });
            }
        }
        return builder;
    }

    protected InputStream resourceInputStream(Resource resource) throws IOException {
        String data = RouteBuilderLoaderSupport.loadResource(resource.getInputStream());
        if (data.trim().isEmpty()) {
            throw new IOException("Resource is empty: " + resource.getLocation());
        }
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract RouteBuilder doLoadRouteBuilder(Resource var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadResource(InputStream in) throws IOException {
        String string;
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        boolean first = true;
        try {
            String line;
            BufferedReader reader = IOHelper.buffered((Reader)isr);
            while ((line = reader.readLine()) != null) {
                if (first && line.startsWith("///usr/bin/env jbang") && line.contains("camel@apache/camel pipe")) {
                    line = "";
                }
                builder.append(line);
                builder.append("\n");
                first = false;
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{isr, in});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{isr, in});
        return string;
    }
}

