/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.ehcache.Cache;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;

public class EhcacheConsumer
extends DefaultConsumer
implements CacheEventListener<Object, Object> {
    private final EhcacheConfiguration configuration;
    private final String cacheName;
    private Cache cache;

    public EhcacheConsumer(EhcacheEndpoint endpoint, String cacheName, EhcacheConfiguration configuration, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
        this.cacheName = cacheName;
    }

    public EhcacheEndpoint getEndpoint() {
        return (EhcacheEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        Class kt = null;
        if (this.configuration.getKeyType() != null) {
            kt = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(this.configuration.getKeyType());
        }
        Class vt = null;
        if (this.configuration.getValueType() != null) {
            vt = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(this.configuration.getValueType());
        }
        this.cache = this.getEndpoint().getManager().getCache(this.cacheName, kt, vt);
        this.cache.getRuntimeConfiguration().registerCacheEventListener((CacheEventListener)this, this.configuration.getEventOrdering(), this.configuration.getEventFiring(), this.configuration.getEventTypesSet());
    }

    protected void doStop() throws Exception {
        this.cache.getRuntimeConfiguration().deregisterCacheEventListener((CacheEventListener)this);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(CacheEvent<?, ?> event) {
        if (this.isRunAllowed()) {
            Exchange exchange = this.createExchange(false);
            Message message = exchange.getIn();
            message.setHeader("CamelEhcacheKey", event.getKey());
            message.setHeader("CamelEhcacheEventType", (Object)event.getType());
            message.setHeader("CamelEhcacheOldValue", event.getOldValue());
            message.setBody(event.getNewValue());
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
            finally {
                this.releaseExchange(exchange, false);
            }
        }
    }
}

