/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.processor.aggregate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(EhcacheAggregationRepository.class);
    private CamelContext camelContext;
    private CacheManager cacheManager;
    private String cacheName;
    private Cache<String, DefaultExchangeHolder> cache;
    private boolean allowSerializedHeaders;
    private boolean useRecovery = true;
    private String deadLetterChannel;
    private long recoveryInterval = 5000L;
    private int maximumRedeliveries = 3;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Cache<String, DefaultExchangeHolder> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, DefaultExchangeHolder> cache) {
        this.cache = cache;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterChannel = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterChannel;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public String getDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public void setDeadLetterChannel(String deadLetterChannel) {
        this.deadLetterChannel = deadLetterChannel;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder oldHolder = (DefaultExchangeHolder)this.cache.get((Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.allowSerializedHeaders);
        this.cache.put((Object)key, (Object)newHolder);
        return EhcacheAggregationRepository.unmarshallExchange(camelContext, oldHolder);
    }

    public Exchange get(CamelContext camelContext, String key) {
        return EhcacheAggregationRepository.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.get((Object)key));
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Removing an exchange with ID {} for key {}", (Object)exchange.getExchangeId(), (Object)key);
        this.cache.remove((Object)key);
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
        this.cache.remove((Object)exchangeId);
    }

    public Set<String> getKeys() {
        HashSet keys = new HashSet();
        this.cache.forEach(e -> keys.add((String)e.getKey()));
        return Collections.unmodifiableSet(keys);
    }

    public Set<String> scan(CamelContext camelContext) {
        LOG.trace("Scanning for exchanges to recover in {} context", (Object)camelContext.getName());
        Set<String> scanned = Collections.unmodifiableSet(this.getKeys());
        LOG.trace("Found {} keys for exchanges to recover in {} context", (Object)scanned.size(), (Object)camelContext.getName());
        return scanned;
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        LOG.trace("Recovering an Exchange with ID {}.", (Object)exchangeId);
        return this.useRecovery ? EhcacheAggregationRepository.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.get((Object)exchangeId)) : null;
    }

    protected void doStart() throws Exception {
        if (this.maximumRedeliveries < 0) {
            throw new IllegalArgumentException("Maximum redelivery retries must be zero or a positive integer.");
        }
        if (this.recoveryInterval < 0L) {
            throw new IllegalArgumentException("Recovery interval must be zero or a positive integer.");
        }
        if (this.cache == null) {
            ObjectHelper.notNull((Object)this.cacheManager, (String)"cacheManager");
            this.cache = this.cacheManager.getCache(this.cacheName, String.class, DefaultExchangeHolder.class);
        }
    }

    protected void doStop() throws Exception {
    }

    public static Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        }
        return exchange;
    }
}

