/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.maven.CamelSpringNamespace;
import org.apache.camel.maven.DocumentationEnricher;
import org.apache.camel.maven.DomFinder;
import org.apache.camel.maven.XmlHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Mojo(name="eip-documentation-enricher", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class EipDocumentationEnricherMojo
extends AbstractMojo {
    @Parameter(required=true)
    public File inputCamelSchemaFile;
    @Parameter(required=true)
    public File outputCamelSchemaFile;
    @Parameter(defaultValue="${project.build.directory}/sources/camel-core-model")
    public File camelCoreModelDir;
    @Parameter(defaultValue="${project.build.directory}/sources/camel-core-xml")
    public File camelCoreXmlDir;
    @Parameter(defaultValue="${project.build.directory}/sources/camel-spring")
    public File camelSpringDir;
    @Parameter(defaultValue="${project.build.directory}/classes")
    public String targetDir;
    @Parameter(defaultValue="META-INF/org/apache/camel/model")
    public String pathToModelDir;
    @Parameter(defaultValue="META-INF/org/apache/camel/core/xml")
    public String pathToCoreXmlModelDir;
    @Parameter(defaultValue="META-INF/org/apache/camel/spring")
    public String pathToSpringModelDir;
    @Parameter
    public String deleteFilesAfterRun;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.pathToModelDir == null) {
            throw new MojoExecutionException("pathToModelDir parameter must not be null");
        }
        if (this.inputCamelSchemaFile == null || !this.inputCamelSchemaFile.exists()) {
            this.getLog().info((CharSequence)("Input Camel schema file: " + String.valueOf(this.inputCamelSchemaFile) + " does not exist. Skip EIP document enrichment"));
            return;
        }
        boolean blueprint = this.targetDir != null && this.targetDir.contains("camel-blueprint");
        this.validateExists(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateIsFile(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateExists(this.camelCoreXmlDir, "camelCoreXmlDir");
        this.validateIsDirectory(this.camelCoreModelDir, "camelCoreModelDir");
        this.validateIsDirectory(this.camelCoreXmlDir, "camelCoreXmlDir");
        if (blueprint) {
            this.validateExists(this.camelSpringDir, "camelSpringDir");
            this.validateIsDirectory(this.camelSpringDir, "camelSpringDir");
        }
        try {
            this.runPlugin(blueprint);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during plugin execution", e);
        }
        if (this.deleteFilesAfterRun != null) {
            this.deleteFilesAfterDone(this.deleteFilesAfterRun);
        }
    }

    private void runPlugin(boolean blueprint) throws Exception {
        Document document = XmlHelper.buildNamespaceAwareDocument(this.inputCamelSchemaFile);
        XPath xPath = XmlHelper.buildXPath(new CamelSpringNamespace());
        DomFinder domFinder = new DomFinder(document, xPath);
        DocumentationEnricher documentationEnricher = new DocumentationEnricher(document);
        HashSet files = new HashSet();
        PackageHelper.findJsonFiles((File)new File(this.camelCoreModelDir, this.pathToModelDir), files);
        PackageHelper.findJsonFiles((File)new File(this.camelCoreXmlDir, this.pathToCoreXmlModelDir), files);
        Predicate<File> filter = f -> !f.getName().equals("errorHandler.json");
        if (blueprint) {
            PackageHelper.findJsonFiles((File)new File(this.camelSpringDir, this.pathToSpringModelDir), files, filter);
        } else {
            PackageHelper.findJsonFiles((File)new File(this.targetDir, this.pathToSpringModelDir), files, filter);
        }
        HashMap<String, File> jsonFiles = new HashMap<String, File>();
        files.forEach(f -> jsonFiles.put(PackageHelper.asName((Path)f.toPath()), (File)f));
        NodeList elementsAndTypes = domFinder.findElementsAndTypes();
        documentationEnricher.enrichTopLevelElementsDocumentation(elementsAndTypes, jsonFiles);
        Map<String, String> typeToNameMap = this.buildTypeToNameMap(elementsAndTypes);
        LinkedHashSet<String> injectedTypes = new LinkedHashSet<String>();
        this.getLog().debug((CharSequence)("Found " + typeToNameMap.size() + " models to use when enriching the XSD schema"));
        int enriched = 0;
        for (Map.Entry<String, String> entry : typeToNameMap.entrySet()) {
            String elementType = entry.getKey();
            String elementName = entry.getValue();
            if (this.jsonFileExistsForElement(jsonFiles, elementName)) {
                ++enriched;
                this.getLog().debug((CharSequence)("Enriching " + elementName));
                File file = (File)jsonFiles.get(elementName);
                this.injectChildElementsDocumentation(domFinder, documentationEnricher, file, elementType, injectedTypes);
                continue;
            }
            boolean ignore = "ExpressionDefinition".equalsIgnoreCase(elementName);
            if (ignore) continue;
            this.getLog().warn((CharSequence)("Cannot find json metadata to use for enriching element " + elementName));
        }
        this.getLog().info((CharSequence)("Enriched " + enriched + " models out of " + typeToNameMap.size() + " models"));
        String xml = this.transformToXml(document, XmlHelper.buildTransformer());
        xml = EipDocumentationEnricherMojo.fixXmlOutput(xml);
        xml = EipDocumentationEnricherMojo.removeEmptyLines(xml);
        this.saveToFile(document, this.outputCamelSchemaFile, xml);
    }

    public static String fixXmlOutput(String xml) {
        xml = xml.replaceAll("><!\\[CDATA\\[", ">\n<![CDATA[");
        xml = xml.replaceAll("\\h+<!\\[CDATA\\[", "<![CDATA[");
        xml = xml.replaceAll("(\\h*)]]><", "]]>\n$1<");
        return EipDocumentationEnricherMojo.removeEmptyLines(xml);
    }

    public static String removeEmptyLines(String xml) {
        StringJoiner sj = new StringJoiner("\n");
        for (String l : xml.split("\n")) {
            if (l.isBlank()) continue;
            sj.add(l);
        }
        return sj.toString();
    }

    private String transformToXml(Document document, Transformer transformer) throws TransformerException {
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return sw.toString();
    }

    private boolean jsonFileExistsForElement(Map<String, File> jsonFiles, String elementName) {
        return jsonFiles.containsKey(elementName);
    }

    private void deleteFilesAfterDone(String deleteFiles) {
        String[] names;
        for (String name : names = deleteFiles.split(",")) {
            File file = new File(name);
            FileUtil.deleteFile((File)file);
        }
    }

    private void injectChildElementsDocumentation(DomFinder domFinder, DocumentationEnricher documentationEnricher, File jsonFile, String type, Set<String> injectedTypes) throws XPathExpressionException {
        String baseType;
        NodeList elementElements;
        if (injectedTypes.contains(type)) {
            return;
        }
        injectedTypes.add(type);
        NodeList attributeElements = domFinder.findAttributesElements(type);
        if (attributeElements.getLength() > 0) {
            documentationEnricher.enrichElementDocumentation(this.getLog(), attributeElements, jsonFile);
        }
        if ((elementElements = domFinder.findElementsElements(type)).getLength() > 0) {
            documentationEnricher.enrichElementDocumentation(this.getLog(), elementElements, jsonFile);
        }
        if ((baseType = domFinder.findBaseType(type)) != null && !StringUtils.isEmpty((CharSequence)baseType)) {
            baseType = this.truncateTypeNamespace(baseType);
            this.injectChildElementsDocumentation(domFinder, documentationEnricher, jsonFile, baseType, injectedTypes);
        }
    }

    private Map<String, String> buildTypeToNameMap(NodeList elementsAndTypes) {
        LinkedHashMap<String, String> typeToNameMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < elementsAndTypes.getLength(); ++i) {
            Element item = (Element)elementsAndTypes.item(i);
            String name = item.getAttribute("name");
            String type = item.getAttribute("type");
            if (name == null || type == null) continue;
            type = this.truncateTypeNamespace(type);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Putting attributes type:'%s', name:'%s'", name, type));
            }
            typeToNameMap.put(type, name);
        }
        return typeToNameMap;
    }

    private String truncateTypeNamespace(String baseType) {
        return baseType.replace("tns:", "");
    }

    private void saveToFile(Document document, File outputFile, String xml) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            os.write(xml.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void validateIsFile(File file, String name) throws MojoExecutionException {
        if (!file.isFile()) {
            throw new MojoExecutionException(name + "is not a file");
        }
    }

    private void validateIsDirectory(File file, String name) throws MojoExecutionException {
        if (!file.isDirectory()) {
            throw new MojoExecutionException(name + "is not a directory");
        }
    }

    private void validateExists(File file, String name) throws MojoExecutionException {
        if (file == null || !file.exists()) {
            throw new MojoExecutionException(name + " does not exist");
        }
    }
}

