/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.maven.XmlHelper;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.commons.text.WordUtils;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentationEnricher {
    private final Document document;

    public DocumentationEnricher(Document document) {
        this.document = document;
    }

    public void enrichTopLevelElementsDocumentation(NodeList elements, Map<String, File> jsonFiles) {
        for (int i = 0; i < elements.getLength(); ++i) {
            Element item = (Element)elements.item(i);
            String name = item.getAttribute("name");
            if (!jsonFiles.containsKey(name)) continue;
            this.addElementDocumentation(item, jsonFiles.get(name));
        }
    }

    public void enrichElementDocumentation(Log log, NodeList elements, File jsonFile) {
        for (int j = 0; j < elements.getLength(); ++j) {
            Element item = (Element)elements.item(j);
            this.addAttributeDocumentation(log, item, jsonFile);
        }
    }

    private void addElementDocumentation(Element item, File jsonFile) {
        BaseModel model = JsonMapper.generateModel((Path)jsonFile.toPath());
        Object descriptionText = model.getDescription();
        if (model.isDeprecated()) {
            descriptionText = "Deprecated: " + (String)descriptionText;
        }
        this.addDocumentation(item, (String)descriptionText);
    }

    private void addAttributeDocumentation(Log log, Element item, File jsonFile) {
        Object defaultValueText;
        String name = item.getAttribute("name");
        if (XmlHelper.isNullOrEmpty(name)) {
            return;
        }
        BaseModel model = JsonMapper.generateModel((Path)jsonFile.toPath());
        BaseOptionModel option = Stream.concat(model.getOptions().stream(), model instanceof ComponentModel ? ((ComponentModel)model).getEndpointOptions().stream() : Stream.empty()).filter(o -> name.equals(o.getName())).findAny().orElse(null);
        Object descriptionText = option != null ? option.getDescription() : null;
        Object object = defaultValueText = option != null ? option.getDefaultValue() : null;
        if ("useBlueprintPropertyResolver".equals(name)) {
            descriptionText = "Whether to automatic detect OSGi Blueprint property placeholder service in use, and bridge with Camel property placeholder. When enabled this allows you to only setup OSGi Blueprint property placeholder and Camel can use the properties in the camelContext.";
        } else if ("binding".equals(name)) {
            descriptionText = "In binding mode we bind the passed in arguments (args) to the created exchange using the existing Camel @Body, @Header, @Headers, @ExchangeProperty annotations if no annotation then its bound as the message body";
        } else if ("serviceRef".equals(name) && jsonFile.getName().endsWith("proxy.json")) {
            descriptionText = "Reference to existing endpoint to lookup by endpoint id in the Camel registry to be used as proxied service";
        }
        if (descriptionText == null || ((String)descriptionText).equals("null")) {
            descriptionText = "";
        }
        if (option != null && option.isDeprecated()) {
            descriptionText = "Deprecated: " + (String)descriptionText;
        }
        if (!XmlHelper.isNullOrEmpty((String)descriptionText)) {
            Object text = descriptionText;
            if (!((String)text).endsWith(".")) {
                text = (String)text + ".";
            }
            if (defaultValueText != null && !"".equals(defaultValueText)) {
                text = (String)text + " Default value: " + String.valueOf(defaultValueText);
            }
            this.addDocumentation(item, (String)text);
        } else {
            boolean skip;
            boolean bl = skip = "customId".equals(name) || "inheritErrorHandler".equals(name) || "rest".equals(name) && jsonFile.getName().endsWith("route.json");
            if (!skip) {
                log.warn((CharSequence)("Cannot find documentation for name: " + name + " in json schema: " + String.valueOf(jsonFile)));
            }
        }
    }

    private void addDocumentation(Element item, String textContent) {
        Element annotation = this.document.createElement("xs:annotation");
        Element documentation = this.document.createElement("xs:documentation");
        documentation.setAttribute("xml:lang", "en");
        CDATASection cdataDocumentationText = this.document.createCDATASection(this.formatTextContent(item, textContent));
        documentation.appendChild(cdataDocumentationText);
        annotation.appendChild(documentation);
        if (item.getFirstChild() != null) {
            item.insertBefore(annotation, item.getFirstChild());
        } else {
            item.appendChild(annotation);
        }
    }

    private String formatTextContent(Element item, String textContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n").append(WordUtils.wrap((String)textContent, (int)120)).append("\n");
        stringBuilder.append("  ");
        for (Node parent = item.getParentNode(); parent != null; parent = parent.getParentNode()) {
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }
}

