/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ElasticsearchEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":clusterName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "elasticsearch-rest".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "clusterName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(18);
        props.add("waitForActiveShards");
        props.add("disconnect");
        props.add("sniffAfterFailureDelay");
        props.add("maxRetryTimeout");
        props.add("indexName");
        props.add("enableSniffer");
        props.add("hostAddresses");
        props.add("scrollKeepAliveMs");
        props.add("snifferInterval");
        props.add("enableSSL");
        props.add("lazyStartProducer");
        props.add("size");
        props.add("clusterName");
        props.add("socketTimeout");
        props.add("from");
        props.add("useScroll");
        props.add("connectionTimeout");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

