/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.elasticsearch.converter.ElasticsearchActionRequestConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;

@DeferredContextBinding
public final class ElasticsearchActionRequestConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, DeleteIndexRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toDeleteIndexRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, BulkRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toBulkRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, DeleteRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toDeleteRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, GetRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toGetRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, IndexRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toIndexRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, SearchRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toSearchRequest(value, exchange));
        ElasticsearchActionRequestConverterLoader.addTypeConverter(registry, UpdateRequest.class, Object.class, false, (type, exchange, value) -> ElasticsearchActionRequestConverter.toUpdateRequest(value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

