/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.elasticsearch.client.RestClient;

@UriEndpoint(firstVersion="2.21.0", scheme="elasticsearch-rest", title="Elasticsearch Rest", syntax="elasticsearch-rest:clusterName", producerOnly=true, category={Category.SEARCH, Category.MONITORING})
public class ElasticsearchEndpoint
extends DefaultEndpoint {
    @UriParam
    private final ElasticsearchConfiguration configuration;
    private RestClient client;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, ElasticsearchConfiguration config, RestClient client) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
        this.client = client;
    }

    public ElasticsearchConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public RestClient getClient() {
        return this.client;
    }
}

