/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MsearchRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.es.ElasticsearchConfiguration;
import org.apache.camel.component.es.ElasticsearchEndpoint;
import org.apache.camel.component.es.ElasticsearchOperation;
import org.apache.camel.component.es.ElasticsearchScrollRequestIterator;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchProducer.class);
    protected final ElasticsearchConfiguration configuration;
    private volatile RestClient client;
    private volatile Sniffer sniffer;

    public ElasticsearchProducer(ElasticsearchEndpoint endpoint, ElasticsearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.client = endpoint.getClient();
    }

    private ElasticsearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return ElasticsearchOperation.Index;
        }
        if (request instanceof GetRequest) {
            return ElasticsearchOperation.GetById;
        }
        if (request instanceof MgetRequest) {
            return ElasticsearchOperation.MultiGet;
        }
        if (request instanceof UpdateRequest) {
            return ElasticsearchOperation.Update;
        }
        if (request instanceof BulkRequest) {
            return ElasticsearchOperation.Bulk;
        }
        if (request instanceof DeleteRequest) {
            return ElasticsearchOperation.Delete;
        }
        if (request instanceof SearchRequest) {
            return ElasticsearchOperation.Search;
        }
        if (request instanceof MsearchRequest) {
            return ElasticsearchOperation.MultiSearch;
        }
        if (request instanceof DeleteIndexRequest) {
            return ElasticsearchOperation.DeleteIndex;
        }
        ElasticsearchOperation operationConfig = (ElasticsearchOperation)((Object)exchange.getIn().getHeader("operation", ElasticsearchOperation.class));
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + operationConfig + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        Class<?> documentClass;
        Integer from;
        Integer size;
        if (this.configuration.isDisconnect() && this.client == null) {
            this.startClient();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        RestClientTransport transport = new RestClientTransport(this.client, (JsonpMapper)new JacksonJsonpMapper(mapper));
        ElasticsearchClient esClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        Message message = exchange.getIn();
        ElasticsearchOperation operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.configuration.getIndexName());
            configIndexName = true;
        }
        if ((size = (Integer)message.getHeader("size", Integer.class)) == null) {
            message.setHeader("size", (Object)this.configuration.getSize());
        }
        if ((from = (Integer)message.getHeader("from", Integer.class)) == null) {
            message.setHeader("from", (Object)this.configuration.getFrom());
        }
        boolean configWaitForActiveShards = false;
        Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
        if (waitForActiveShards == null) {
            message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
            configWaitForActiveShards = true;
        }
        if ((documentClass = (Class<?>)message.getHeader("documentClass", Class.class)) == null) {
            documentClass = this.configuration.getDocumentClass();
        }
        switch (operation) {
            case Index: {
                IndexRequest.Builder indexRequestBuilder = (IndexRequest.Builder)message.getBody(IndexRequest.Builder.class);
                message.setBody((Object)esClient.index(indexRequestBuilder.build()).id());
                break;
            }
            case Update: {
                UpdateRequest.Builder updateRequestBuilder = (UpdateRequest.Builder)message.getBody(UpdateRequest.Builder.class);
                message.setBody((Object)esClient.update(updateRequestBuilder.build(), documentClass).id());
                break;
            }
            case GetById: {
                GetRequest.Builder getRequestBuilder = (GetRequest.Builder)message.getBody(GetRequest.Builder.class);
                if (getRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only String or GetRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.get(getRequestBuilder.build(), documentClass));
                break;
            }
            case Bulk: {
                BulkRequest.Builder bulkRequestBuilder = (BulkRequest.Builder)message.getBody(BulkRequest.Builder.class);
                if (bulkRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only Iterable or BulkRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.bulk(bulkRequestBuilder.build()).items());
                break;
            }
            case Delete: {
                DeleteRequest.Builder deleteRequestBuilder = (DeleteRequest.Builder)message.getBody(DeleteRequest.Builder.class);
                if (deleteRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only String or DeleteRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.delete(deleteRequestBuilder.build()).result());
                break;
            }
            case DeleteIndex: {
                DeleteIndexRequest.Builder deleteIndexRequestBuilder = (DeleteIndexRequest.Builder)message.getBody(DeleteIndexRequest.Builder.class);
                if (deleteIndexRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only String or DeleteIndexRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.indices().delete(deleteIndexRequestBuilder.build()).acknowledged());
                break;
            }
            case Exists: {
                ExistsRequest.Builder builder = new ExistsRequest.Builder();
                builder.index((String)exchange.getIn().getHeader("indexName", String.class), new String[0]);
                message.setBody((Object)esClient.indices().exists(builder.build()).value());
                break;
            }
            case Search: {
                SearchRequest.Builder searchRequestBuilder = (SearchRequest.Builder)message.getBody(SearchRequest.Builder.class);
                if (searchRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only Map, String or SearchRequest.Builder is allowed as a type");
                }
                boolean useScroll = (Boolean)message.getHeader("useScroll", (Object)this.configuration.isUseScroll(), Boolean.class);
                if (useScroll) {
                    int scrollKeepAliveMs = (Integer)message.getHeader("scrollKeepAliveMs", (Object)this.configuration.getScrollKeepAliveMs(), Integer.class);
                    ElasticsearchScrollRequestIterator scrollRequestIterator = new ElasticsearchScrollRequestIterator(searchRequestBuilder, esClient, scrollKeepAliveMs, exchange, documentClass);
                    exchange.getIn().setBody(scrollRequestIterator);
                    break;
                }
                message.setBody((Object)esClient.search(searchRequestBuilder.build(), documentClass).hits());
                break;
            }
            case MultiSearch: {
                MsearchRequest.Builder msearchRequestBuilder = (MsearchRequest.Builder)message.getBody(MsearchRequest.Builder.class);
                if (msearchRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only MsearchRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.msearch(msearchRequestBuilder.build(), documentClass).responses());
                break;
            }
            case MultiGet: {
                MgetRequest.Builder mgetRequestBuilder = (MgetRequest.Builder)message.getBody(MgetRequest.Builder.class);
                if (mgetRequestBuilder == null) {
                    throw new IllegalArgumentException("Wrong body type. Only MgetRequest.Builder is allowed as a type");
                }
                message.setBody((Object)esClient.mget(mgetRequestBuilder.build(), documentClass).docs());
                break;
            }
            case Ping: {
                message.setBody((Object)esClient.ping().value());
                break;
            }
            default: {
                throw new IllegalArgumentException("operation value '" + operation + "' is not supported");
            }
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configWaitForActiveShards) {
            message.removeHeader("waitForActiveShards");
        }
        if (this.configuration.isDisconnect()) {
            IOHelper.close((Closeable)transport);
            IOHelper.close((Closeable)this.client);
            this.client = null;
            if (this.configuration.isEnableSniffer()) {
                IOHelper.close((Closeable)this.sniffer);
                this.sniffer = null;
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.isDisconnect()) {
            this.startClient();
        }
    }

    private void startClient() {
        if (this.client == null) {
            LOG.info("Connecting to the ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            if (this.configuration.getHostAddressesList() != null && !this.configuration.getHostAddressesList().isEmpty()) {
                this.client = this.createClient();
            } else {
                LOG.warn("Incorrect ip address and port parameters settings for ElasticSearch cluster");
            }
        }
    }

    private RestClient createClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.configuration.getHostAddressesList().toArray(new HttpHost[0]));
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.configuration.getConnectionTimeout()).setSocketTimeout(this.configuration.getSocketTimeout()));
        if (this.configuration.getUser() != null && this.configuration.getPassword() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.getUser(), this.configuration.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> this.lambda$createClient$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        if (this.configuration.isEnableSniffer()) {
            SnifferBuilder snifferBuilder = Sniffer.builder((RestClient)restClient);
            snifferBuilder.setSniffIntervalMillis(this.configuration.getSnifferInterval());
            snifferBuilder.setSniffAfterFailureDelayMillis(this.configuration.getSniffAfterFailureDelay());
            this.sniffer = snifferBuilder.build();
        }
        return restClient;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            this.client.close();
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        super.doStop();
    }

    public RestClient getClient() {
        return this.client;
    }

    private SSLContext createSslContextFromCa() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate trustedCa = factory.generateCertificate(new ByteArrayInputStream(Files.readAllBytes(Paths.get(this.configuration.getCertificatePath(), new String[0]))));
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$createClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.configuration.getCertificatePath() != null) {
            httpClientBuilder.setSSLContext(this.createSslContextFromCa());
        }
        return httpClientBuilder;
    }
}

