/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.util.URISupport;

@XmlTransient
public class AbstractEndpointBuilder {
    protected final String scheme;
    protected final String path;
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AbstractEndpointBuilder(String scheme, String path) {
        this.scheme = scheme;
        this.path = path;
    }

    public Endpoint resolve(CamelContext context) throws NoSuchEndpointException {
        HashMap<String, Object> remaining = new HashMap<String, Object>();
        String uri = this.computeUri(remaining);
        Endpoint endpoint = context.getEndpoint(uri, this.properties);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public String getUri() {
        return this.computeUri(new HashMap<String, Object>());
    }

    protected String computeUri(Map<String, Object> remaining) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String || val instanceof Number || val instanceof Boolean || val instanceof Enum) {
                params.put(key, val.toString());
                continue;
            }
            remaining.put(key, val);
        }
        if (!remaining.isEmpty()) {
            params.put("hash", Integer.toHexString(remaining.hashCode()));
        }
        if (params.isEmpty()) {
            return this.scheme + ":" + this.path;
        }
        try {
            String query = URISupport.createQueryString(params);
            return this.scheme + ":" + this.path + "?" + query;
        }
        catch (URISyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String toString() {
        return this.getUri();
    }

    public void doSetProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Expression expr() {
        return SimpleBuilder.simple((String)this.getUri());
    }
}

