/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Perform operations against Corda blockchain platform using corda-rpc library.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CordaEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Corda component.
     */
    public interface CordaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCordaEndpointConsumerBuilder advanced() {
            return (AdvancedCordaEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * PageSpecification allows specification of a page number (starting
         * from 1) and page size (defaulting to 200 with a maximum page size of
         * (Integer.MAX_INT) Note: we default the page number to 200 to enable
         * queries without requiring a page specification but enabling detection
         * of large results sets that fall out of the 200 requirement. Max page
         * size should be used with extreme caution as results may exceed your
         * JVM memory footprint.
         * 
         * The option is a:
         * &lt;code&gt;net.corda.core.node.services.vault.PageSpecification&lt;/code&gt; type.
         * 
         * Default: 200
         * Group: consumer
         * 
         * @param pageSpecification the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder pageSpecification(
                Object pageSpecification) {
            doSetProperty("pageSpecification", pageSpecification);
            return this;
        }
        /**
         * PageSpecification allows specification of a page number (starting
         * from 1) and page size (defaulting to 200 with a maximum page size of
         * (Integer.MAX_INT) Note: we default the page number to 200 to enable
         * queries without requiring a page specification but enabling detection
         * of large results sets that fall out of the 200 requirement. Max page
         * size should be used with extreme caution as results may exceed your
         * JVM memory footprint.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.corda.core.node.services.vault.PageSpecification&lt;/code&gt; type.
         * 
         * Default: 200
         * Group: consumer
         * 
         * @param pageSpecification the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder pageSpecification(
                String pageSpecification) {
            doSetProperty("pageSpecification", pageSpecification);
            return this;
        }
        /**
         * Whether to process snapshots or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param processSnapshot the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder processSnapshot(
                boolean processSnapshot) {
            doSetProperty("processSnapshot", processSnapshot);
            return this;
        }
        /**
         * Whether to process snapshots or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param processSnapshot the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder processSnapshot(
                String processSnapshot) {
            doSetProperty("processSnapshot", processSnapshot);
            return this;
        }
        /**
         * Sort allows specification of a set of entity attribute names and
         * their associated directionality and null handling, to be applied upon
         * processing a query specification.
         * 
         * The option is a:
         * &lt;code&gt;net.corda.core.node.services.vault.Sort&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param sort the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder sort(Object sort) {
            doSetProperty("sort", sort);
            return this;
        }
        /**
         * Sort allows specification of a set of entity attribute names and
         * their associated directionality and null handling, to be applied upon
         * processing a query specification.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.corda.core.node.services.vault.Sort&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param sort the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder sort(String sort) {
            doSetProperty("sort", sort);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CordaEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Corda component.
     */
    public interface AdvancedCordaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CordaEndpointConsumerBuilder basic() {
            return (CordaEndpointConsumerBuilder) this;
        }
        /**
         * A contract state (or just state) contains opaque data used by a
         * contract program. It can be thought of as a disk file that the
         * program can use to persist data across transactions. States are
         * immutable: once created they are never updated, instead, any changes
         * must generate a new successor state. States can be updated (consumed)
         * only once: the notary is responsible for ensuring there is no double
         * spending by only signing a transaction if the input states are all
         * free.
         * 
         * The option is a:
         * &lt;code&gt;java.lang.Class&amp;lt;net.corda.core.contracts.ContractState&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param contractStateClass the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder contractStateClass(
                Class<Object> contractStateClass) {
            doSetProperty("contractStateClass", contractStateClass);
            return this;
        }
        /**
         * A contract state (or just state) contains opaque data used by a
         * contract program. It can be thought of as a disk file that the
         * program can use to persist data across transactions. States are
         * immutable: once created they are never updated, instead, any changes
         * must generate a new successor state. States can be updated (consumed)
         * only once: the notary is responsible for ensuring there is no double
         * spending by only signing a transaction if the input states are all
         * free.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class&amp;lt;net.corda.core.contracts.ContractState&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param contractStateClass the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder contractStateClass(
                String contractStateClass) {
            doSetProperty("contractStateClass", contractStateClass);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Start the given flow with the given arguments, returning an
         * Observable with a single observation of the result of running the
         * flow. The flowLogicClass must be annotated with
         * net.corda.core.flows.StartableByRPC.
         * 
         * The option is a: &lt;code&gt;java.lang.Object[]&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param flowLogicArguments the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder flowLogicArguments(
                Object[] flowLogicArguments) {
            doSetProperty("flowLogicArguments", flowLogicArguments);
            return this;
        }
        /**
         * Start the given flow with the given arguments, returning an
         * Observable with a single observation of the result of running the
         * flow. The flowLogicClass must be annotated with
         * net.corda.core.flows.StartableByRPC.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object[]&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param flowLogicArguments the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder flowLogicArguments(
                String flowLogicArguments) {
            doSetProperty("flowLogicArguments", flowLogicArguments);
            return this;
        }
        /**
         * Start the given flow with the given arguments, returning an
         * Observable with a single observation of the result of running the
         * flow. The flowLogicClass must be annotated with
         * net.corda.core.flows.StartableByRPC.
         * 
         * The option is a:
         * &lt;code&gt;java.lang.Class&amp;lt;net.corda.core.flows.FlowLogic&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param flowLogicClass the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder flowLogicClass(
                Class<Object> flowLogicClass) {
            doSetProperty("flowLogicClass", flowLogicClass);
            return this;
        }
        /**
         * Start the given flow with the given arguments, returning an
         * Observable with a single observation of the result of running the
         * flow. The flowLogicClass must be annotated with
         * net.corda.core.flows.StartableByRPC.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Class&amp;lt;net.corda.core.flows.FlowLogic&amp;lt;java.lang.Object&amp;gt;&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param flowLogicClass the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder flowLogicClass(
                String flowLogicClass) {
            doSetProperty("flowLogicClass", flowLogicClass);
            return this;
        }
        /**
         * QueryCriteria assumes underlying schema tables are correctly indexed
         * for performance.
         * 
         * The option is a:
         * &lt;code&gt;net.corda.core.node.services.vault.QueryCriteria&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param queryCriteria the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder queryCriteria(
                Object queryCriteria) {
            doSetProperty("queryCriteria", queryCriteria);
            return this;
        }
        /**
         * QueryCriteria assumes underlying schema tables are correctly indexed
         * for performance.
         * 
         * The option will be converted to a
         * &lt;code&gt;net.corda.core.node.services.vault.QueryCriteria&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param queryCriteria the value to set
         * @return the dsl builder
         */
        default AdvancedCordaEndpointConsumerBuilder queryCriteria(
                String queryCriteria) {
            doSetProperty("queryCriteria", queryCriteria);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Corda component.
     */
    public interface CordaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCordaEndpointProducerBuilder advanced() {
            return (AdvancedCordaEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default CordaEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default CordaEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Operation to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CordaEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CordaEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CordaEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Corda component.
     */
    public interface AdvancedCordaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CordaEndpointProducerBuilder basic() {
            return (CordaEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Corda component.
     */
    public interface CordaEndpointBuilder
            extends
                CordaEndpointConsumerBuilder,
                CordaEndpointProducerBuilder {
        default AdvancedCordaEndpointBuilder advanced() {
            return (AdvancedCordaEndpointBuilder) this;
        }
        /**
         * Password for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CordaEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CordaEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Corda component.
     */
    public interface AdvancedCordaEndpointBuilder
            extends
                AdvancedCordaEndpointConsumerBuilder,
                AdvancedCordaEndpointProducerBuilder {
        default CordaEndpointBuilder basic() {
            return (CordaEndpointBuilder) this;
        }
    }

    public interface CordaBuilders {
        /**
         * Corda (camel-corda)
         * Perform operations against Corda blockchain platform using corda-rpc
         * library.
         * 
         * Category: blockchain,rpc
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-corda
         * 
         * Syntax: <code>corda:node</code>
         * 
         * Path parameter: node (required)
         * The url for the corda node
         * 
         * @param path node
         * @return the dsl builder
         */
        default CordaEndpointBuilder corda(String path) {
            return CordaEndpointBuilderFactory.endpointBuilder("corda", path);
        }
        /**
         * Corda (camel-corda)
         * Perform operations against Corda blockchain platform using corda-rpc
         * library.
         * 
         * Category: blockchain,rpc
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-corda
         * 
         * Syntax: <code>corda:node</code>
         * 
         * Path parameter: node (required)
         * The url for the corda node
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path node
         * @return the dsl builder
         */
        default CordaEndpointBuilder corda(String componentName, String path) {
            return CordaEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static CordaEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class CordaEndpointBuilderImpl extends AbstractEndpointBuilder implements CordaEndpointBuilder, AdvancedCordaEndpointBuilder {
            public CordaEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CordaEndpointBuilderImpl(path);
    }
}