/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send GraphQL queries and mutations to external systems.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GraphqlEndpointBuilderFactory {


    /**
     * Builder for endpoint for the GraphQL component.
     */
    public interface GraphqlEndpointBuilder extends EndpointProducerBuilder {
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The query or mutation name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operationName the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder operationName(String operationName) {
            doSetProperty("operationName", operationName);
            return this;
        }
        /**
         * The proxy host in the format hostname:port.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The query text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The query file name located in the classpath.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryFile the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder queryFile(String queryFile) {
            doSetProperty("queryFile", queryFile);
            return this;
        }
        /**
         * The name of a header containing the GraphQL query.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryHeader the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder queryHeader(String queryHeader) {
            doSetProperty("queryHeader", queryHeader);
            return this;
        }
        /**
         * The JsonObject instance containing the operation variables.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.util.json.JsonObject&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder variables(Object variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * The JsonObject instance containing the operation variables.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.util.json.JsonObject&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * The name of a header containing a JsonObject instance containing the
         * operation variables.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param variablesHeader the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder variablesHeader(String variablesHeader) {
            doSetProperty("variablesHeader", variablesHeader);
            return this;
        }
        /**
         * The access token sent in the Authorization header.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessToken the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The JWT Authorization type. Default is Bearer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Bearer
         * Group: security
         * 
         * @param jwtAuthorizationType the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder jwtAuthorizationType(
                String jwtAuthorizationType) {
            doSetProperty("jwtAuthorizationType", jwtAuthorizationType);
            return this;
        }
        /**
         * The password for Basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username for Basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    public interface GraphqlBuilders {
        /**
         * GraphQL (camel-graphql)
         * Send GraphQL queries and mutations to external systems.
         * 
         * Category: api
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-graphql
         * 
         * Syntax: <code>graphql:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The GraphQL server URI.
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder graphql(String path) {
            return GraphqlEndpointBuilderFactory.endpointBuilder("graphql", path);
        }
        /**
         * GraphQL (camel-graphql)
         * Send GraphQL queries and mutations to external systems.
         * 
         * Category: api
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-graphql
         * 
         * Syntax: <code>graphql:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The GraphQL server URI.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         * @return the dsl builder
         */
        default GraphqlEndpointBuilder graphql(String componentName, String path) {
            return GraphqlEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static GraphqlEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class GraphqlEndpointBuilderImpl extends AbstractEndpointBuilder implements GraphqlEndpointBuilder {
            public GraphqlEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new GraphqlEndpointBuilderImpl(path);
    }
}