/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Execute commands on remote hosts using SSH.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SshEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SSH component.
     */
    public interface SshEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSshEndpointConsumerBuilder advanced() {
            return (AdvancedSshEndpointConsumerBuilder) this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder failOnUnknownHost(
                boolean failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder failOnUnknownHost(
                String failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Sets the resource path for a known_hosts file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param knownHostsResource the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder knownHostsResource(
                String knownHostsResource) {
            doSetProperty("knownHostsResource", knownHostsResource);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the command string to send to the remote SSH server during every
         * poll cycle. Only works with camel-ssh component being used as a
         * consumer, i.e. from(ssh://...) You may need to end your command with
         * a newline, and that must be URL encoded %0A.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param pollCommand the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder pollCommand(String pollCommand) {
            doSetProperty("pollCommand", pollCommand);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Sets the resource path of the certificate to use for Authentication.
         * Will use ResourceHelperKeyPairProvider to resolve file based
         * certificate, and depends on keyType setting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResource the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder certResource(String certResource) {
            doSetProperty("certResource", certResource);
            return this;
        }
        /**
         * Sets the password to use in loading certResource, if certResource is
         * an encrypted key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResourcePassword the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder certResourcePassword(
                String certResourcePassword) {
            doSetProperty("certResourcePassword", certResourcePassword);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder keyPairProvider(
                org.apache.sshd.common.keyprovider.KeyPairProvider keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder keyPairProvider(
                String keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the key type to pass to the KeyPairProvider as part of
         * authentication. KeyPairProvider.loadKey(...) will be passed this
         * value. From Camel 3.0.0 / 2.25.0, by default Camel will select the
         * first available KeyPair that is loaded. Prior to this, a KeyType of
         * 'ssh-rsa' was enforced by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * Sets the password to use in connecting to remote SSH server. Requires
         * keyPairProvider to be set to null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username to use in logging into the remote SSH server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SshEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SSH component.
     */
    public interface AdvancedSshEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SshEndpointConsumerBuilder basic() {
            return (SshEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Sets the channel type to pass to the Channel as part of command
         * execution. Defaults to exec.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: exec
         * Group: advanced
         * 
         * @param channelType the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder channelType(
                String channelType) {
            doSetProperty("channelType", channelType);
            return this;
        }
        /**
         * Sets the shellPrompt to be dropped when response is read after
         * command execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param shellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder shellPrompt(
                String shellPrompt) {
            doSetProperty("shellPrompt", shellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder sleepForShellPrompt(
                long sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointConsumerBuilder sleepForShellPrompt(
                String sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SSH component.
     */
    public interface SshEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSshEndpointProducerBuilder advanced() {
            return (AdvancedSshEndpointProducerBuilder) this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder failOnUnknownHost(
                boolean failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder failOnUnknownHost(
                String failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Sets the resource path for a known_hosts file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param knownHostsResource the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder knownHostsResource(
                String knownHostsResource) {
            doSetProperty("knownHostsResource", knownHostsResource);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the resource path of the certificate to use for Authentication.
         * Will use ResourceHelperKeyPairProvider to resolve file based
         * certificate, and depends on keyType setting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResource the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder certResource(String certResource) {
            doSetProperty("certResource", certResource);
            return this;
        }
        /**
         * Sets the password to use in loading certResource, if certResource is
         * an encrypted key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResourcePassword the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder certResourcePassword(
                String certResourcePassword) {
            doSetProperty("certResourcePassword", certResourcePassword);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder keyPairProvider(
                org.apache.sshd.common.keyprovider.KeyPairProvider keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder keyPairProvider(
                String keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the key type to pass to the KeyPairProvider as part of
         * authentication. KeyPairProvider.loadKey(...) will be passed this
         * value. From Camel 3.0.0 / 2.25.0, by default Camel will select the
         * first available KeyPair that is loaded. Prior to this, a KeyType of
         * 'ssh-rsa' was enforced by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * Sets the password to use in connecting to remote SSH server. Requires
         * keyPairProvider to be set to null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username to use in logging into the remote SSH server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SshEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SSH component.
     */
    public interface AdvancedSshEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SshEndpointProducerBuilder basic() {
            return (SshEndpointProducerBuilder) this;
        }
        /**
         * Sets the channel type to pass to the Channel as part of command
         * execution. Defaults to exec.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: exec
         * Group: advanced
         * 
         * @param channelType the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointProducerBuilder channelType(
                String channelType) {
            doSetProperty("channelType", channelType);
            return this;
        }
        /**
         * Sets the shellPrompt to be dropped when response is read after
         * command execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param shellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointProducerBuilder shellPrompt(
                String shellPrompt) {
            doSetProperty("shellPrompt", shellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointProducerBuilder sleepForShellPrompt(
                long sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointProducerBuilder sleepForShellPrompt(
                String sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SSH component.
     */
    public interface SshEndpointBuilder
            extends
                SshEndpointConsumerBuilder,
                SshEndpointProducerBuilder {
        default AdvancedSshEndpointBuilder advanced() {
            return (AdvancedSshEndpointBuilder) this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder failOnUnknownHost(boolean failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder failOnUnknownHost(String failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Sets the resource path for a known_hosts file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param knownHostsResource the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder knownHostsResource(String knownHostsResource) {
            doSetProperty("knownHostsResource", knownHostsResource);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the resource path of the certificate to use for Authentication.
         * Will use ResourceHelperKeyPairProvider to resolve file based
         * certificate, and depends on keyType setting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResource the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder certResource(String certResource) {
            doSetProperty("certResource", certResource);
            return this;
        }
        /**
         * Sets the password to use in loading certResource, if certResource is
         * an encrypted key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResourcePassword the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder certResourcePassword(
                String certResourcePassword) {
            doSetProperty("certResourcePassword", certResourcePassword);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder keyPairProvider(
                org.apache.sshd.common.keyprovider.KeyPairProvider keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder keyPairProvider(String keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the key type to pass to the KeyPairProvider as part of
         * authentication. KeyPairProvider.loadKey(...) will be passed this
         * value. From Camel 3.0.0 / 2.25.0, by default Camel will select the
         * first available KeyPair that is loaded. Prior to this, a KeyType of
         * 'ssh-rsa' was enforced by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * Sets the password to use in connecting to remote SSH server. Requires
         * keyPairProvider to be set to null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username to use in logging into the remote SSH server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SshEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SSH component.
     */
    public interface AdvancedSshEndpointBuilder
            extends
                AdvancedSshEndpointConsumerBuilder,
                AdvancedSshEndpointProducerBuilder {
        default SshEndpointBuilder basic() {
            return (SshEndpointBuilder) this;
        }
        /**
         * Sets the channel type to pass to the Channel as part of command
         * execution. Defaults to exec.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: exec
         * Group: advanced
         * 
         * @param channelType the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointBuilder channelType(String channelType) {
            doSetProperty("channelType", channelType);
            return this;
        }
        /**
         * Sets the shellPrompt to be dropped when response is read after
         * command execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param shellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointBuilder shellPrompt(String shellPrompt) {
            doSetProperty("shellPrompt", shellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointBuilder sleepForShellPrompt(
                long sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default AdvancedSshEndpointBuilder sleepForShellPrompt(
                String sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
    }

    public interface SshBuilders {
        /**
         * SSH (camel-ssh)
         * Execute commands on remote hosts using SSH.
         * 
         * Category: file
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-ssh
         * 
         * Syntax: <code>ssh:host:port</code>
         * 
         * Path parameter: host (required)
         * Sets the hostname of the remote SSH server.
         * 
         * Path parameter: port
         * Sets the port number for the remote SSH server.
         * Default value: 22
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default SshEndpointBuilder ssh(String path) {
            return SshEndpointBuilderFactory.endpointBuilder("ssh", path);
        }
        /**
         * SSH (camel-ssh)
         * Execute commands on remote hosts using SSH.
         * 
         * Category: file
         * Since: 2.10
         * Maven coordinates: org.apache.camel:camel-ssh
         * 
         * Syntax: <code>ssh:host:port</code>
         * 
         * Path parameter: host (required)
         * Sets the hostname of the remote SSH server.
         * 
         * Path parameter: port
         * Sets the port number for the remote SSH server.
         * Default value: 22
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port
         * @return the dsl builder
         */
        default SshEndpointBuilder ssh(String componentName, String path) {
            return SshEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SshEndpointBuilder endpointBuilder(String componentName, String path) {
        class SshEndpointBuilderImpl extends AbstractEndpointBuilder implements SshEndpointBuilder, AdvancedSshEndpointBuilder {
            public SshEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SshEndpointBuilderImpl(path);
    }
}